// bibiman - a TUI for managing BibLaTeX databases
// Copyright (C) 2024  lukeflo
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.
/////

use app::App;
use cliargs::CLIArgs;
use color_eyre::eyre::Result;
use errorsetup::init_error_hooks;

pub mod app;
pub mod bibiman;
pub mod cliargs;
pub mod config;
pub mod errorsetup;
pub mod tui;

#[tokio::main]
async fn main() -> Result<()> {
    // Parse CLI arguments
    let (mut parsed_args, mut cfg, run_tui) = CLIArgs::parse_args()?;

    if run_tui {
        init_error_hooks()?;

        // Create an application.
        let mut app = App::new(&mut parsed_args, &mut cfg)?;

        app.run(&cfg).await?;
    }

    Ok(())
}
