---
title: SLSA provenance
---

BuildKit supports automatic creation of provenance attestations for the build
process. Provenance attestations record information describing how a build was
created, and is important for tracking the security of your software artifacts.

Provenance attestations created by BuildKit include details such as:

- Build parameters and environment.
- Build timestamps.
- Version control metadata for your build sources.
- Build dependencies with their immutable checksums. For example, base images or external URLs used by the build.
- Descriptions of all build steps, with their source and layer mappings.

Provenance generated by BuildKit is wrapped inside [in-toto attestations](https://github.com/in-toto/attestation)
in the [SLSA Provenance format](https://slsa.dev/provenance/v0.2).

For more information about how the attestation fields get generated, see [SLSA definitions](./slsa-definitions.md).

## Build with provenance attestations

To build an image with provenance attestations using `buildctl`, use the `attest:provenance` option:

```bash
buildctl build \
    --frontend=dockerfile.v0 \
    --local context=. \
    --local dockerfile=. \
    --opt attest:provenance=
```

You can also customize the attestations using parameters:

```bash
buildctl build \
    --frontend=dockerfile.v0 \
    --local context=. \
    --local dockerfile=. \
    --opt attest:provenance=mode=min,inline-only=true
```

All BuildKit exporters support attaching attestations to build results.
When the final output format is a container image (`image` or `oci` exporter), provenance is attached
to the image using the format described in the [attestation storage specification](./attestation-storage.md).
When creating a multi-platform image, each platform version of the image gets its own provenance.

If you use the `local` or `tar` exporter, the provenance will be written to a file named `provenance.json`
and exported with your build result, in the root directory.

## Parameters

| Parameter      | Type           | Default           | Description                                                                                                 |
| -------------- | -------------- | ---------------- | ----------------------------------------------------------------------------------------------------------- |
| `mode`         | `min`,`max`    | `max`             | Configures the amount of provenance to be generated. See [mode](#mode)                                      |
| `builder-id`   | String         |                   | Explicitly set SLSA [`builder.id`](https://slsa.dev/provenance/v0.2#builder.id) field                       |
| `filename`     | String         | `provenance.json` | Set filename for provenance attestation when exported with `local` or `tar` exporter |
| `reproducible` | `true`,`false` | `false`           | Explicitly set SLSA [`metadata.reproducible`](https://slsa.dev/provenance/v0.2#metadata.reproducible) field |
| `inline-only`  | `true`,`false` | `false`           | Only embed provenance into exporters that support inline content. See [inline-only](#inline-only)           |

### `mode`

Provenance can be generated in one of two modes: `min` or `max`. By default,
when provenance is enabled, the `mode` parameter will be set to `max`.

In `min` mode, BuildKit generates only the bare minimum amount of provenance,
including:

- Build timestamps
- The frontend used
- The build materials

However, the values of build arguments, the identities of secrets, and rich
layer metadata will not be included. `mode=min` should be safe to set on all
builds, as it does not leak information from any part of the build environment.

In `max` mode, BuildKit generates all of the above, as well as:

- The source Dockerfile, and rich layer metadata with sourcemaps to connect the
  source with the build result
- The values of passed build arguments
- Metadata about secrets and ssh mounts

Wherever possible, you should prefer `mode=max` as it contains significantly
more detailed information for analysis. However, on some builds it may not be
appropriate, as it includes the values of various build arguments and metadata
about secrets - these builds should be refactored to prefer passing hidden
values through secrets wherever possible to prevent unnecessary information
leakage.

### `inline-only`

By default, provenance is by included in all exporters that support
attestations. The `inline-only` parameter allows configuring this behavior, to
only include the provenance results in exporters that support inline content,
specifically only exporters that produce container images.

Since other exporters produce attestations into separate files, in their
filesystems, you may not want to include the provenance in these cases.

