import { OtGlyph } from "@ot-builder/ot-glyphs";
import { DicingStore, Gpos } from "@ot-builder/ot-layout";
import { Data } from "@ot-builder/prelude";
import { SubtableWriteContext } from "../../gsub-gpos-shared/general";
export declare class AdjStore {
    indexMatrix: ReadonlyArray<ReadonlyArray<number>>;
    adjustments: ReadonlyArray<Gpos.AdjustmentPair>;
    constructor(indexMatrix: ReadonlyArray<ReadonlyArray<number>>, adjustments: ReadonlyArray<Gpos.AdjustmentPair>);
}
export declare class ClassMatrix<G> {
    cFirst: G[][];
    cSecond: G[][];
    adjStore: AdjStore;
    constructor(cFirst: G[][], // Per-class glyph list for first glyph. Class 0 reserved for neutral
    cSecond: G[][], // Per-class glyph list for second glyph. Class 0 reserved for neutral
    adjStore: AdjStore);
    derive(): ClassMatrix<G>;
    bisect(allowUneven: boolean): [ClassMatrix<G>, ClassMatrix<G>];
    mergeFirstClass(c1p: number, c1t: number): void;
    mergeSecondClass(c2p: number, c2t: number): void;
    firstClassValid(c1: number): number;
    secondClassValid(c2: number): number;
    getEffectiveFirstClasses(): number;
    getEffectiveSecondClasses(): number;
    eliminateZeroClasses(): void;
    get(c1: number, c2: number): Gpos.AdjustmentPair;
    static analyze(ds: DicingStore<OtGlyph, OtGlyph, Gpos.AdjustmentPair>, ctx: SubtableWriteContext<Gpos.Lookup>): ClassMatrix<OtGlyph>;
    measure(): {
        effFst: {
            count: number;
            glyphs: number;
        };
        effSnd: {
            count: number;
            glyphs: number;
        };
        size: number;
    };
    sort(ord: Data.Order<G>): void;
    private getRelocation;
}
//# sourceMappingURL=class-matrix.d.ts.map