# Historical GIMP logos

This page inventorizes historical, official variants of our software's
logo/mascot: Wilber.

Note that the Wilber-s here have not all necessarily been in use in the
software itself. Some variants were only used on the website, or "for
fun", or in other ways. The actual usage will be written next to each
image when known.

This page is kept up-to-date mostly for "Free Software archeologists"
who want to discover the evolution of the project. It also allows to
easily delete images from the website while keeping easy-to-retrieve
links.

## Logos

* [GIMP 3.0](logo/README.md) by Aryeom in 2024, under [Creative Commons
  Attribution-ShareAlike 4.0](https://creativecommons.org/licenses/by-sa/3.0/) license:

  ![Current GIMP logo](logo/gimp-logo.svg)

  The new developer logo introduced in the same time, also by Aryeom in
  2024 with the same license, is:

  ![Current GIMP developer logo](logo/gimp-devel-logo.svg)

  Among other usage, it is being used as logo in the [API
  references](https://developer.gimp.org/api/3.0/libgimp/) or in the
  `About` dialog for unstable builds.

  On macOS, the logo is shown in a white rounded-corner rectangle since
  GIMP 3.0.8. Based on the logo by Aryeom, edited by Bruno Lopes without
  clipping on the brush to work around macOS SVG reader limitations:

  ![GIMP icon for macOS since
  3.0.8](https://gitlab.gnome.org/GNOME/gimp-data/-/raw/b08f4e9777630c6ba60c2235e734452934f8786f/images/logo/gimp-logo-macos.svg)

  From GIMP 3.0.0 to 3.0.6, we used to have a more special variant of
  the logo on macOS: Wilber over an easel, designed by Aryeom in 2024,
  under CC By-SA 4.0:

  ![GIMP icon for macOS (3.0.0 to 3.0.6)](https://gitlab.gnome.org/GNOME/gimp-data/-/raw/71ed1c651ab207c19c8b0a8b5312b03f35d3c5ce/images/logo/gimp-logo-macos.svg)

  The small-size variant (when displayed under 48×48) on macOS was
  simpler for readability:

  ![GIMP icon (small variant) for macOS (3.0.0 to 3.0.6)](https://gitlab.gnome.org/GNOME/gimp-data/-/raw/71ed1c651ab207c19c8b0a8b5312b03f35d3c5ce/images/logo/gimp-logo-macos-small.svg)

  Apple's former <abbr title="Human Interface Guidelines">HIG</abbr>
  used to recommend playing with the icon's rounded shape into familiar
  skeuomorphic shapes. This recommendation ended with macOS 26 Tahoe,
  where they'd move to different icon design requirements.

* [GIMP 2.6, 2.8 and 2.10](https://gitlab.gnome.org/GNOME/gimp/-/blob/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/gimp-logo.png)
  by Jakub Steiner in 2008 under [Creative Commons by-sa 3.0](https://creativecommons.org/licenses/by-sa/3.0/):

  ![GIMP 2.6 to 2.10 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/gimp-logo.png)

  In the same time, the [developer
  logo](https://gitlab.gnome.org/GNOME/gimp/-/commit/f9ea72123880de1976e8bace2fbca015ac312845)
  was introduced, though it was not used until GIMP 2.7 (then 2.9, 2.99…)
  releases:

  ![GIMP 2.7 to 2.99 development logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/wilber-devel.png)

  The source file for the logo was [committed to repository](https://gitlab.gnome.org/GNOME/gimp/-/blob/0579cb949be212e540a345e79f4c4b503206d5fa/desktop/src/gimp.svg)
  as SVG with variants for various sizes:

  ![Vectorial source file of GIMP 2.6 to 2.10 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/0579cb949be212e540a345e79f4c4b503206d5fa/desktop/src/gimp.svg)

* [GIMP 2.4](https://gitlab.gnome.org/GNOME/gimp/-/blob/b520a3eece0e06d24a98d6d2c7ee359b2b8e13cd/data/images/gimp-logo.png) by Jakub Steiner.

  ![GIMP 2.4 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/b520a3eece0e06d24a98d6d2c7ee359b2b8e13cd/data/images/gimp-logo.png)

* [Pre-GIMP 2.4](https://gitlab.gnome.org/GNOME/gimp/-/blob/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)
  by Jakub Steiner in 2006. This version was never used and soon changed.

  ![pre-GIMP 2.4 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)

* Link buttons: authorship and creation dates are unsure. The oldest
  found reference was [from a 2003
  commit](https://gitlab.gnome.org/Infrastructure/gimp-web/-/commit/0753589d15a12a71ea0d36f2724207703da91341)
  already calling these images "old". They used to be proposed on a
  "*Linking to Us*" page on `gimp.org` for third-party websites wishing
  to link to our website. These buttons have been hidden away in 2025,
  though we left them in the `images/` directory just in case some
  websites still use them directly.

  !["Graphics by GIMP" link button](https://www.gimp.org/images/gfx_by_gimp.png)
  !["GIMP - Free" link button](https://www.gimp.org/images/gimp_free_button.png)

* [Wilber Construction Kit](https://gitlab.gnome.org/GNOME/gimp/-/commit/f9ea72123880de1976e8bace2fbca015ac312845)
  adding accessories to the original Wilber by various team members, between
  2000 to 2005: Simon Budig (hard hat), Raphaël Quinet (wizard hat),
  Jens Lautenbacher, Sven Neumann, Seth Burgess, Ville Pätsi, Guillermo
  S. Romero, Carol Spears…

  ![Wilber, the GIMP mascot](https://gitlab.gnome.org/Infrastructure/gimp-web/-/raw/50b10b2e81062028bafe354a836c05aa00be214b/content/images/wilber_the_gimp.png)
  ![Wilber, the GIMP mascot](https://gitlab.gnome.org/Infrastructure/gimp-web/-/raw/50b10b2e81062028bafe354a836c05aa00be214b/content/images/wilber_the_gimp2.png)
  ![Wilber painter](https://gitlab.gnome.org/Infrastructure/gimp-web/-/raw/50b10b2e81062028bafe354a836c05aa00be214b/content/images/wilber_painter.png)
  ![Wilber worker](https://gitlab.gnome.org/Infrastructure/gimp-web/-/raw/50b10b2e81062028bafe354a836c05aa00be214b/content/images/wilber_work.png)
  ![Wilber wizard](https://gitlab.gnome.org/Infrastructure/gimp-web/-/raw/50b10b2e81062028bafe354a836c05aa00be214b/content/images/wilber_wizard.png)

  The [Wizard Wilber](https://gitlab.gnome.org/GNOME/gimp/-/blob/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-wizard.png)
  was added in 2002 for the user installation dialog but is not used
  anymore in modern GIMP (we just use the "gimp-wilber-eek" icon
  instead).

* [SVG variant](https://gitlab.gnome.org/GNOME/gimp/-/blob/e33ff2b0895f8622051f310ca000f48ad45b5981/docs/Wilber.svg)
  by Simon Budig in 2000.

  ![SVG variant](https://gitlab.gnome.org/GNOME/gimp/-/raw/e6c52afb6e14915f64336ca4885f70f04e07bb8c/docs/Wilber.svg)

* [French painter Wilber](https://gitlab.gnome.org/GNOME/gimp/-/blob/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-tips.png)
  exists since the start (1997), first as `app/wilber.h` [header
  file](https://gitlab.gnome.org/GNOME/gimp/-/blob/32cefec8f76ccb20f1bf3f9311843ca47c1101c8/app/wilber.h),
  then as [XMP](https://gitlab.gnome.org/GNOME/gimp/-/blob/f765a8216f29e0f4f56af767f582e5df59ae606b/pixmaps/wilber3.xpm),
  before getting its final PNG format. It was used for the "Tip of the day"
  popup (nowadays, we just use "dialog-information" icon).

  ![French painter Wilber](https://gitlab.gnome.org/GNOME/gimp/-/raw/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-tips.png)

* [Original Wilber](https://gitlab.gnome.org/GNOME/gimp/-/commit/a4e97e61f982d3039d9d594de9477a5104491c52)
  by Tuomas Kuosmanen.

  ![Original Wilber](https://gitlab.gnome.org/GNOME/gimp/-/raw/925a16359732509beb04c9896ffff67ea4022735/desktop/gimp.png)

  - [XCF file](https://gitlab.gnome.org/GNOME/gimp/-/blob/a4e97e61f982d3039d9d594de9477a5104491c52/docs/Wilber.xcf.gz)
  - [README/Licensing](https://gitlab.gnome.org/GNOME/gimp/-/blob/a4e97e61f982d3039d9d594de9477a5104491c52/docs/Wilber.xcf.gz.README)

## About dialog images

We make a separate section for the "About" dialog which used to have its own
dedicated image from early GIMP until GIMP 2.2. In GIMP 2.4 until today, the
About dialog shows the application logo.

* [GIMP 2.7 (unstable release)](https://gitlab.gnome.org/GNOME/gimp/-/blob/f959832666f8ab0a2af719ee5106c7d59701502f/data/images/gimp-devel-logo.png):
  from this version and onward, stable releases (even minor version) were still
  using the logo whereas even releases (odd minor version) were using a
  dedicated development logo (Wilber with a hard hat).

  ![GIMP 2.7 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/f959832666f8ab0a2af719ee5106c7d59701502f/data/images/gimp-devel-logo.png)

* GIMP 2.4: from this version, the About dialog simply used the application logo. See GIMP 2.4 application logo.

  ![GIMP 2.4 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)

* [GIMP 2.2](https://gitlab.gnome.org/GNOME/gimp/-/blob/c075dab29e494dd596ce84e9548a9b6e7f8c8a6b/data/images/gimp-logo.png) by Philip Lafleur.

  ![GIMP 2.2 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/c075dab29e494dd596ce84e9548a9b6e7f8c8a6b/data/images/gimp-logo.png)

* [GIMP 1.4 to 2.0](https://gitlab.gnome.org/GNOME/gimp/-/blob/8cdcee9626db576be7eacf57a2207348da26b3c3/data/images/gimp_logo.png):
  by Jakub Stenier.

  ![GIMP 1.4 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/8cdcee9626db576be7eacf57a2207348da26b3c3/data/images/gimp_logo.png)

* [Between GIMP 1.3.24 to 1.3.25](https://gitlab.gnome.org/GNOME/gimp/-/blob/c48c9370425be886c25fd9cf2252e87d2306ec12/data/images/gimp_logo.png):
  by Jakub Steiner. This image was never used in a release but a cropped version
  of it.

  ![GIMP 1.3 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/c48c9370425be886c25fd9cf2252e87d2306ec12/data/images/gimp_logo.png)

* [GIMP 1.2](https://gitlab.gnome.org/GNOME/gimp/-/blob/52776aa6d4e4c0534ced4ad33cd3f09fa3ebd7cc/data/images/gimp_logo.ppm): "Wilber & Sons"

  ![GIMP 1.2 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/be1215a221aa534118086425f361954b27427455/data/images/gimp_logo.png)

* [GIMP 1.0](https://gitlab.gnome.org/GNOME/gimp/-/blob/a3c0b515f9c39cbf0dc6ba9525ae2ea0a369ec5e/data/images/gimp-logo-1.0.png):
  This logo was used since the [early
  start](https://gitlab.gnome.org/GNOME/gimp/-/commit/32cefec8f76ccb20f1bf3f9311843ca47c1101c8) under the name `gimp_logo.ppm`.
  Author is uncertain, though the commit author is Elliot Lee.
  From reading `git log`, it looks like it was just used for the About dialog
  while the software logo may have already been Wilber.

  ![GIMP 1.0 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/a3c0b515f9c39cbf0dc6ba9525ae2ea0a369ec5e/data/images/gimp-logo-1.0.png)
