//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetFunctionAppStacks.json
func ExampleProviderClient_NewGetFunctionAppStacksPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderClient().NewGetFunctionAppStacksPager(&armappservice.ProviderClientGetFunctionAppStacksOptions{StackOsType: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FunctionAppStackCollection = armappservice.FunctionAppStackCollection{
		// 	Value: []*armappservice.FunctionAppStack{
		// 		{
		// 			Name: to.Ptr("dotnet"),
		// 			Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/dotnet"),
		// 			Properties: &armappservice.FunctionAppStackProperties{
		// 				DisplayText: to.Ptr(".NET"),
		// 				MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 3"),
		// 						MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.1"),
		// 								StackSettings: &armappservice.FunctionAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										AppSettingsDictionary: map[string]*string{
		// 											"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("dotnet|3.1"),
		// 										SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 											LinuxFxVersion: to.Ptr("dotnet|3.1"),
		// 											Use32BitWorkerProcess: to.Ptr(false),
		// 										},
		// 										SupportedFunctionsExtensionVersions: []*string{
		// 											to.Ptr("~3")},
		// 										},
		// 										WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 											AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 												IsSupported: to.Ptr(true),
		// 											},
		// 											AppSettingsDictionary: map[string]*string{
		// 												"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 											},
		// 											GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 												IsSupported: to.Ptr(true),
		// 												SupportedVersion: to.Ptr("3.1.301"),
		// 											},
		// 											RemoteDebuggingSupported: to.Ptr(false),
		// 											RuntimeVersion: to.Ptr("3.1"),
		// 											SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 												Use32BitWorkerProcess: to.Ptr(true),
		// 											},
		// 											SupportedFunctionsExtensionVersions: []*string{
		// 												to.Ptr("~3")},
		// 											},
		// 										},
		// 										Value: to.Ptr("3.1"),
		// 								}},
		// 								Value: to.Ptr("3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2"),
		// 								MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 									{
		// 										DisplayText: to.Ptr(".NET Core 2.2"),
		// 										StackSettings: &armappservice.FunctionAppRuntimes{
		// 											LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 												AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 													IsSupported: to.Ptr(true),
		// 												},
		// 												AppSettingsDictionary: map[string]*string{
		// 													"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 												},
		// 												GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 													IsSupported: to.Ptr(true),
		// 													SupportedVersion: to.Ptr("2.2.207"),
		// 												},
		// 												RemoteDebuggingSupported: to.Ptr(false),
		// 												RuntimeVersion: to.Ptr("dotnet|2.2"),
		// 												SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 													LinuxFxVersion: to.Ptr("dotnet|2.2"),
		// 													Use32BitWorkerProcess: to.Ptr(false),
		// 												},
		// 												SupportedFunctionsExtensionVersions: []*string{
		// 													to.Ptr("~2")},
		// 												},
		// 												WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 													AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 														IsSupported: to.Ptr(true),
		// 													},
		// 													AppSettingsDictionary: map[string]*string{
		// 														"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 													},
		// 													GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 														IsSupported: to.Ptr(true),
		// 														SupportedVersion: to.Ptr("2.2.207"),
		// 													},
		// 													RemoteDebuggingSupported: to.Ptr(false),
		// 													RuntimeVersion: to.Ptr("2.2"),
		// 													SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 														Use32BitWorkerProcess: to.Ptr(true),
		// 													},
		// 													SupportedFunctionsExtensionVersions: []*string{
		// 														to.Ptr("~2")},
		// 													},
		// 												},
		// 												Value: to.Ptr("2.2"),
		// 										}},
		// 										Value: to.Ptr("2"),
		// 									},
		// 									{
		// 										DisplayText: to.Ptr(".NET Framework 4"),
		// 										MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 											{
		// 												DisplayText: to.Ptr(".NET Framework 4.7"),
		// 												StackSettings: &armappservice.FunctionAppRuntimes{
		// 													WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 														AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 															IsSupported: to.Ptr(true),
		// 														},
		// 														AppSettingsDictionary: map[string]*string{
		// 														},
		// 														GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 															IsSupported: to.Ptr(false),
		// 														},
		// 														RemoteDebuggingSupported: to.Ptr(false),
		// 														RuntimeVersion: to.Ptr("4.7"),
		// 														SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 															Use32BitWorkerProcess: to.Ptr(true),
		// 														},
		// 														SupportedFunctionsExtensionVersions: []*string{
		// 															to.Ptr("~1")},
		// 														},
		// 													},
		// 													Value: to.Ptr("4.7"),
		// 											}},
		// 											Value: to.Ptr("2"),
		// 									}},
		// 									PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 									Value: to.Ptr("dotnet"),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("node"),
		// 								Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 								ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/node"),
		// 								Properties: &armappservice.FunctionAppStackProperties{
		// 									DisplayText: to.Ptr("Node.js"),
		// 									MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 										{
		// 											DisplayText: to.Ptr("Node.js 14"),
		// 											MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 												{
		// 													DisplayText: to.Ptr("Node.js 14 LTS"),
		// 													StackSettings: &armappservice.FunctionAppRuntimes{
		// 														LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 															AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																IsSupported: to.Ptr(true),
		// 															},
		// 															AppSettingsDictionary: map[string]*string{
		// 																"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 															},
		// 															GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																IsSupported: to.Ptr(true),
		// 																SupportedVersion: to.Ptr("14.x"),
		// 															},
		// 															IsHidden: to.Ptr(true),
		// 															IsPreview: to.Ptr(true),
		// 															RemoteDebuggingSupported: to.Ptr(false),
		// 															RuntimeVersion: to.Ptr("Node|14"),
		// 															SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																LinuxFxVersion: to.Ptr("Node|14"),
		// 																Use32BitWorkerProcess: to.Ptr(false),
		// 															},
		// 															SupportedFunctionsExtensionVersions: []*string{
		// 																to.Ptr("~3")},
		// 															},
		// 															WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																	IsSupported: to.Ptr(true),
		// 																},
		// 																AppSettingsDictionary: map[string]*string{
		// 																	"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																	"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~14"),
		// 																},
		// 																GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																	IsSupported: to.Ptr(true),
		// 																	SupportedVersion: to.Ptr("14.x"),
		// 																},
		// 																IsHidden: to.Ptr(true),
		// 																IsPreview: to.Ptr(true),
		// 																RemoteDebuggingSupported: to.Ptr(false),
		// 																RuntimeVersion: to.Ptr("~14"),
		// 																SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																	Use32BitWorkerProcess: to.Ptr(true),
		// 																},
		// 																SupportedFunctionsExtensionVersions: []*string{
		// 																	to.Ptr("~3")},
		// 																},
		// 															},
		// 															Value: to.Ptr("14 LTS"),
		// 													}},
		// 													Value: to.Ptr("14"),
		// 												},
		// 												{
		// 													DisplayText: to.Ptr("Node.js 12"),
		// 													MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 														{
		// 															DisplayText: to.Ptr("Node.js 12 LTS"),
		// 															StackSettings: &armappservice.FunctionAppRuntimes{
		// 																LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																	AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																		IsSupported: to.Ptr(true),
		// 																	},
		// 																	AppSettingsDictionary: map[string]*string{
		// 																		"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																	},
		// 																	GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																		IsSupported: to.Ptr(true),
		// 																		SupportedVersion: to.Ptr("12.x"),
		// 																	},
		// 																	RemoteDebuggingSupported: to.Ptr(false),
		// 																	RuntimeVersion: to.Ptr("Node|12"),
		// 																	SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																		LinuxFxVersion: to.Ptr("Node|12"),
		// 																		Use32BitWorkerProcess: to.Ptr(false),
		// 																	},
		// 																	SupportedFunctionsExtensionVersions: []*string{
		// 																		to.Ptr("~3")},
		// 																	},
		// 																	WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																		AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																			IsSupported: to.Ptr(true),
		// 																		},
		// 																		AppSettingsDictionary: map[string]*string{
		// 																			"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																			"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~12"),
		// 																		},
		// 																		GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																			IsSupported: to.Ptr(true),
		// 																			SupportedVersion: to.Ptr("12.x"),
		// 																		},
		// 																		RemoteDebuggingSupported: to.Ptr(false),
		// 																		RuntimeVersion: to.Ptr("~12"),
		// 																		SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																			Use32BitWorkerProcess: to.Ptr(true),
		// 																		},
		// 																		SupportedFunctionsExtensionVersions: []*string{
		// 																			to.Ptr("~3")},
		// 																		},
		// 																	},
		// 																	Value: to.Ptr("12 LTS"),
		// 															}},
		// 															Value: to.Ptr("12"),
		// 														},
		// 														{
		// 															DisplayText: to.Ptr("Node.js 10"),
		// 															MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																{
		// 																	DisplayText: to.Ptr("Node.js 10 LTS"),
		// 																	StackSettings: &armappservice.FunctionAppRuntimes{
		// 																		LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																			AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																				IsSupported: to.Ptr(true),
		// 																			},
		// 																			AppSettingsDictionary: map[string]*string{
		// 																				"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																			},
		// 																			GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																				IsSupported: to.Ptr(true),
		// 																				SupportedVersion: to.Ptr("10.x"),
		// 																			},
		// 																			RemoteDebuggingSupported: to.Ptr(false),
		// 																			RuntimeVersion: to.Ptr("Node|10"),
		// 																			SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																				LinuxFxVersion: to.Ptr("Node|10"),
		// 																				Use32BitWorkerProcess: to.Ptr(false),
		// 																			},
		// 																			SupportedFunctionsExtensionVersions: []*string{
		// 																				to.Ptr("~2"),
		// 																				to.Ptr("~3")},
		// 																			},
		// 																			WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																				AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																					IsSupported: to.Ptr(true),
		// 																				},
		// 																				AppSettingsDictionary: map[string]*string{
		// 																					"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																					"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~10"),
		// 																				},
		// 																				GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																					IsSupported: to.Ptr(true),
		// 																					SupportedVersion: to.Ptr("10.x"),
		// 																				},
		// 																				RemoteDebuggingSupported: to.Ptr(false),
		// 																				RuntimeVersion: to.Ptr("~10"),
		// 																				SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																					Use32BitWorkerProcess: to.Ptr(true),
		// 																				},
		// 																				SupportedFunctionsExtensionVersions: []*string{
		// 																					to.Ptr("~2"),
		// 																					to.Ptr("~3")},
		// 																				},
		// 																			},
		// 																			Value: to.Ptr("10 LTS"),
		// 																	}},
		// 																	Value: to.Ptr("10"),
		// 																},
		// 																{
		// 																	DisplayText: to.Ptr("Node.js 8"),
		// 																	MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																		{
		// 																			DisplayText: to.Ptr("Node.js 8 LTS"),
		// 																			StackSettings: &armappservice.FunctionAppRuntimes{
		// 																				WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																					AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																						IsSupported: to.Ptr(true),
		// 																					},
		// 																					AppSettingsDictionary: map[string]*string{
		// 																						"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																						"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~8"),
		// 																					},
		// 																					GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																						IsSupported: to.Ptr(true),
		// 																						SupportedVersion: to.Ptr("8.x"),
		// 																					},
		// 																					RemoteDebuggingSupported: to.Ptr(false),
		// 																					RuntimeVersion: to.Ptr("~8"),
		// 																					SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																						Use32BitWorkerProcess: to.Ptr(true),
		// 																					},
		// 																					SupportedFunctionsExtensionVersions: []*string{
		// 																						to.Ptr("~2")},
		// 																					},
		// 																				},
		// 																				Value: to.Ptr("8 LTS"),
		// 																		}},
		// 																		Value: to.Ptr("8"),
		// 																	},
		// 																	{
		// 																		DisplayText: to.Ptr("Node.js 6"),
		// 																		MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																			{
		// 																				DisplayText: to.Ptr("Node.js 6 LTS"),
		// 																				StackSettings: &armappservice.FunctionAppRuntimes{
		// 																					WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																						AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																							IsSupported: to.Ptr(true),
		// 																						},
		// 																						AppSettingsDictionary: map[string]*string{
		// 																							"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~6"),
		// 																						},
		// 																						GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																							IsSupported: to.Ptr(false),
		// 																						},
		// 																						RemoteDebuggingSupported: to.Ptr(false),
		// 																						RuntimeVersion: to.Ptr("~6"),
		// 																						SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																							Use32BitWorkerProcess: to.Ptr(true),
		// 																						},
		// 																						SupportedFunctionsExtensionVersions: []*string{
		// 																							to.Ptr("~1")},
		// 																						},
		// 																					},
		// 																					Value: to.Ptr("6 LTS"),
		// 																			}},
		// 																			Value: to.Ptr("6"),
		// 																	}},
		// 																	PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																	Value: to.Ptr("node"),
		// 																},
		// 															},
		// 															{
		// 																Name: to.Ptr("python"),
		// 																Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 																ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/python"),
		// 																Properties: &armappservice.FunctionAppStackProperties{
		// 																	DisplayText: to.Ptr("Python"),
		// 																	MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																		{
		// 																			DisplayText: to.Ptr("Python 3"),
		// 																			MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																				{
		// 																					DisplayText: to.Ptr("Python 3.8"),
		// 																					StackSettings: &armappservice.FunctionAppRuntimes{
		// 																						LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																							AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																								IsSupported: to.Ptr(true),
		// 																							},
		// 																							AppSettingsDictionary: map[string]*string{
		// 																								"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																							},
		// 																							GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																								IsSupported: to.Ptr(true),
		// 																								SupportedVersion: to.Ptr("3.8"),
		// 																							},
		// 																							RemoteDebuggingSupported: to.Ptr(false),
		// 																							RuntimeVersion: to.Ptr("Python|3.8"),
		// 																							SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																								LinuxFxVersion: to.Ptr("Python|3.8"),
		// 																								Use32BitWorkerProcess: to.Ptr(false),
		// 																							},
		// 																							SupportedFunctionsExtensionVersions: []*string{
		// 																								to.Ptr("~3")},
		// 																							},
		// 																						},
		// 																						Value: to.Ptr("3.8"),
		// 																					},
		// 																					{
		// 																						DisplayText: to.Ptr("Python 3.7"),
		// 																						StackSettings: &armappservice.FunctionAppRuntimes{
		// 																							LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																								AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																									IsSupported: to.Ptr(true),
		// 																								},
		// 																								AppSettingsDictionary: map[string]*string{
		// 																									"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																								},
		// 																								GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																									IsSupported: to.Ptr(true),
		// 																									SupportedVersion: to.Ptr("3.7"),
		// 																								},
		// 																								RemoteDebuggingSupported: to.Ptr(false),
		// 																								RuntimeVersion: to.Ptr("Python|3.7"),
		// 																								SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																									LinuxFxVersion: to.Ptr("Python|3.7"),
		// 																									Use32BitWorkerProcess: to.Ptr(false),
		// 																								},
		// 																								SupportedFunctionsExtensionVersions: []*string{
		// 																									to.Ptr("~2"),
		// 																									to.Ptr("~3")},
		// 																								},
		// 																							},
		// 																							Value: to.Ptr("3.7"),
		// 																						},
		// 																						{
		// 																							DisplayText: to.Ptr("Python 3.6"),
		// 																							StackSettings: &armappservice.FunctionAppRuntimes{
		// 																								LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																									AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																										IsSupported: to.Ptr(true),
		// 																									},
		// 																									AppSettingsDictionary: map[string]*string{
		// 																										"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																									},
		// 																									GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																										IsSupported: to.Ptr(true),
		// 																										SupportedVersion: to.Ptr("3.6"),
		// 																									},
		// 																									RemoteDebuggingSupported: to.Ptr(false),
		// 																									RuntimeVersion: to.Ptr("Python|3.6"),
		// 																									SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																										LinuxFxVersion: to.Ptr("Python|3.6"),
		// 																										Use32BitWorkerProcess: to.Ptr(false),
		// 																									},
		// 																									SupportedFunctionsExtensionVersions: []*string{
		// 																										to.Ptr("~2"),
		// 																										to.Ptr("~3")},
		// 																									},
		// 																								},
		// 																								Value: to.Ptr("3.6"),
		// 																						}},
		// 																						Value: to.Ptr("3"),
		// 																				}},
		// 																				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 																				Value: to.Ptr("python"),
		// 																			},
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("java"),
		// 																			Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 																			ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/java"),
		// 																			Properties: &armappservice.FunctionAppStackProperties{
		// 																				DisplayText: to.Ptr("Java"),
		// 																				MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																					{
		// 																						DisplayText: to.Ptr("Java 11"),
		// 																						MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																							{
		// 																								DisplayText: to.Ptr("Java 11"),
		// 																								StackSettings: &armappservice.FunctionAppRuntimes{
		// 																									LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																											IsSupported: to.Ptr(true),
		// 																										},
		// 																										AppSettingsDictionary: map[string]*string{
		// 																											"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																										},
		// 																										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																											IsSupported: to.Ptr(true),
		// 																											SupportedVersion: to.Ptr("11"),
		// 																										},
		// 																										IsAutoUpdate: to.Ptr(true),
		// 																										RemoteDebuggingSupported: to.Ptr(false),
		// 																										RuntimeVersion: to.Ptr("Java|11"),
		// 																										SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																											LinuxFxVersion: to.Ptr("Java|11"),
		// 																											Use32BitWorkerProcess: to.Ptr(false),
		// 																										},
		// 																										SupportedFunctionsExtensionVersions: []*string{
		// 																											to.Ptr("~3")},
		// 																										},
		// 																										WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																											AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																												IsSupported: to.Ptr(true),
		// 																											},
		// 																											AppSettingsDictionary: map[string]*string{
		// 																												"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																											},
		// 																											GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																												IsSupported: to.Ptr(true),
		// 																												SupportedVersion: to.Ptr("11"),
		// 																											},
		// 																											IsAutoUpdate: to.Ptr(true),
		// 																											RemoteDebuggingSupported: to.Ptr(false),
		// 																											RuntimeVersion: to.Ptr("11"),
		// 																											SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																												JavaVersion: to.Ptr("11"),
		// 																												Use32BitWorkerProcess: to.Ptr(true),
		// 																											},
		// 																											SupportedFunctionsExtensionVersions: []*string{
		// 																												to.Ptr("~3")},
		// 																											},
		// 																										},
		// 																										Value: to.Ptr("11.0"),
		// 																								}},
		// 																								Value: to.Ptr("11"),
		// 																							},
		// 																							{
		// 																								DisplayText: to.Ptr("Java 8"),
		// 																								MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																									{
		// 																										DisplayText: to.Ptr("Java 8"),
		// 																										StackSettings: &armappservice.FunctionAppRuntimes{
		// 																											LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																												AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																													IsSupported: to.Ptr(true),
		// 																												},
		// 																												AppSettingsDictionary: map[string]*string{
		// 																													"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																												},
		// 																												GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																													IsSupported: to.Ptr(true),
		// 																													SupportedVersion: to.Ptr("8"),
		// 																												},
		// 																												IsAutoUpdate: to.Ptr(true),
		// 																												IsDefault: to.Ptr(true),
		// 																												RemoteDebuggingSupported: to.Ptr(false),
		// 																												RuntimeVersion: to.Ptr("Java|8"),
		// 																												SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																													LinuxFxVersion: to.Ptr("Java|8"),
		// 																													Use32BitWorkerProcess: to.Ptr(false),
		// 																												},
		// 																												SupportedFunctionsExtensionVersions: []*string{
		// 																													to.Ptr("~3")},
		// 																												},
		// 																												WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																													AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																														IsSupported: to.Ptr(true),
		// 																													},
		// 																													AppSettingsDictionary: map[string]*string{
		// 																														"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																													},
		// 																													GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																														IsSupported: to.Ptr(true),
		// 																														SupportedVersion: to.Ptr("8"),
		// 																													},
		// 																													IsAutoUpdate: to.Ptr(true),
		// 																													IsDefault: to.Ptr(true),
		// 																													RemoteDebuggingSupported: to.Ptr(false),
		// 																													RuntimeVersion: to.Ptr("1.8"),
		// 																													SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																														JavaVersion: to.Ptr("1.8"),
		// 																														Use32BitWorkerProcess: to.Ptr(true),
		// 																													},
		// 																													SupportedFunctionsExtensionVersions: []*string{
		// 																														to.Ptr("~2"),
		// 																														to.Ptr("~3")},
		// 																													},
		// 																												},
		// 																												Value: to.Ptr("8.0"),
		// 																										}},
		// 																										Value: to.Ptr("8"),
		// 																								}},
		// 																								PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																								Value: to.Ptr("java"),
		// 																							},
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("powershell"),
		// 																							Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 																							ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/powershell"),
		// 																							Properties: &armappservice.FunctionAppStackProperties{
		// 																								DisplayText: to.Ptr("PowerShell Core"),
		// 																								MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																									{
		// 																										DisplayText: to.Ptr("PowerShell 7"),
		// 																										MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																											{
		// 																												DisplayText: to.Ptr("PowerShell 7.0"),
		// 																												StackSettings: &armappservice.FunctionAppRuntimes{
		// 																													WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																														AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																															IsSupported: to.Ptr(true),
		// 																														},
		// 																														AppSettingsDictionary: map[string]*string{
		// 																															"FUNCTIONS_WORKER_RUNTIME": to.Ptr("powershell"),
		// 																														},
		// 																														GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																															IsSupported: to.Ptr(false),
		// 																														},
		// 																														RemoteDebuggingSupported: to.Ptr(false),
		// 																														RuntimeVersion: to.Ptr("~7"),
		// 																														SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																															PowerShellVersion: to.Ptr("~7"),
		// 																															Use32BitWorkerProcess: to.Ptr(true),
		// 																														},
		// 																														SupportedFunctionsExtensionVersions: []*string{
		// 																															to.Ptr("~3")},
		// 																														},
		// 																													},
		// 																													Value: to.Ptr("7.0"),
		// 																											}},
		// 																											Value: to.Ptr("7"),
		// 																										},
		// 																										{
		// 																											DisplayText: to.Ptr("PowerShell Core 6"),
		// 																											MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																												{
		// 																													DisplayText: to.Ptr("PowerShell Core 6.2"),
		// 																													StackSettings: &armappservice.FunctionAppRuntimes{
		// 																														WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																															AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																IsSupported: to.Ptr(true),
		// 																															},
		// 																															AppSettingsDictionary: map[string]*string{
		// 																																"FUNCTIONS_WORKER_RUNTIME": to.Ptr("powershell"),
		// 																															},
		// 																															EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-04T00:00:00.000Z"); return t}()),
		// 																															GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																IsSupported: to.Ptr(false),
		// 																															},
		// 																															IsDeprecated: to.Ptr(true),
		// 																															RemoteDebuggingSupported: to.Ptr(false),
		// 																															RuntimeVersion: to.Ptr("~6"),
		// 																															SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																PowerShellVersion: to.Ptr("~6"),
		// 																																Use32BitWorkerProcess: to.Ptr(true),
		// 																															},
		// 																															SupportedFunctionsExtensionVersions: []*string{
		// 																																to.Ptr("~2"),
		// 																																to.Ptr("~3")},
		// 																															},
		// 																														},
		// 																														Value: to.Ptr("6.2"),
		// 																												}},
		// 																												Value: to.Ptr("6"),
		// 																										}},
		// 																										PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																										Value: to.Ptr("powershell"),
		// 																									},
		// 																								},
		// 																								{
		// 																									Name: to.Ptr("custom"),
		// 																									Type: to.Ptr("Microsoft.Web/functionAppStacks"),
		// 																									ID: to.Ptr("/providers/Microsoft.Web/functionAppStacks/custom"),
		// 																									Properties: &armappservice.FunctionAppStackProperties{
		// 																										DisplayText: to.Ptr("Custom"),
		// 																										MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																											{
		// 																												DisplayText: to.Ptr("Custom"),
		// 																												MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																													{
		// 																														DisplayText: to.Ptr("Custom Handler"),
		// 																														StackSettings: &armappservice.FunctionAppRuntimes{
		// 																															LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																																AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																	IsSupported: to.Ptr(true),
		// 																																},
		// 																																AppSettingsDictionary: map[string]*string{
		// 																																	"FUNCTIONS_WORKER_RUNTIME": to.Ptr("custom"),
		// 																																},
		// 																																GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																	IsSupported: to.Ptr(false),
		// 																																},
		// 																																IsPreview: to.Ptr(true),
		// 																																RemoteDebuggingSupported: to.Ptr(false),
		// 																																RuntimeVersion: to.Ptr(""),
		// 																																SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																	LinuxFxVersion: to.Ptr(""),
		// 																																	Use32BitWorkerProcess: to.Ptr(false),
		// 																																},
		// 																																SupportedFunctionsExtensionVersions: []*string{
		// 																																	to.Ptr("~3"),
		// 																																	to.Ptr("~2")},
		// 																																},
		// 																																WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																																	AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																		IsSupported: to.Ptr(true),
		// 																																	},
		// 																																	AppSettingsDictionary: map[string]*string{
		// 																																		"FUNCTIONS_WORKER_RUNTIME": to.Ptr("custom"),
		// 																																	},
		// 																																	GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																		IsSupported: to.Ptr(false),
		// 																																	},
		// 																																	IsPreview: to.Ptr(true),
		// 																																	RemoteDebuggingSupported: to.Ptr(false),
		// 																																	RuntimeVersion: to.Ptr("custom"),
		// 																																	SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																		Use32BitWorkerProcess: to.Ptr(true),
		// 																																	},
		// 																																	SupportedFunctionsExtensionVersions: []*string{
		// 																																		to.Ptr("~3"),
		// 																																		to.Ptr("~2")},
		// 																																	},
		// 																																},
		// 																																Value: to.Ptr("custom"),
		// 																														}},
		// 																														Value: to.Ptr("custom"),
		// 																												}},
		// 																												PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																												Value: to.Ptr("custom"),
		// 																											},
		// 																									}},
		// 																								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetFunctionAppStacksForLocation.json
func ExampleProviderClient_NewGetFunctionAppStacksForLocationPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderClient().NewGetFunctionAppStacksForLocationPager("westus", &armappservice.ProviderClientGetFunctionAppStacksForLocationOptions{StackOsType: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FunctionAppStackCollection = armappservice.FunctionAppStackCollection{
		// 	Value: []*armappservice.FunctionAppStack{
		// 		{
		// 			Name: to.Ptr("dotnet"),
		// 			Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/dotnet"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.FunctionAppStackProperties{
		// 				DisplayText: to.Ptr(".NET"),
		// 				MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 3"),
		// 						MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.1"),
		// 								StackSettings: &armappservice.FunctionAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										AppSettingsDictionary: map[string]*string{
		// 											"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("dotnet|3.1"),
		// 										SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 											LinuxFxVersion: to.Ptr("dotnet|3.1"),
		// 											Use32BitWorkerProcess: to.Ptr(false),
		// 										},
		// 										SupportedFunctionsExtensionVersions: []*string{
		// 											to.Ptr("~3")},
		// 										},
		// 										WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 											AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 												IsSupported: to.Ptr(true),
		// 											},
		// 											AppSettingsDictionary: map[string]*string{
		// 												"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 											},
		// 											GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 												IsSupported: to.Ptr(true),
		// 												SupportedVersion: to.Ptr("3.1.301"),
		// 											},
		// 											RemoteDebuggingSupported: to.Ptr(false),
		// 											RuntimeVersion: to.Ptr("3.1"),
		// 											SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 												Use32BitWorkerProcess: to.Ptr(true),
		// 											},
		// 											SupportedFunctionsExtensionVersions: []*string{
		// 												to.Ptr("~3")},
		// 											},
		// 										},
		// 										Value: to.Ptr("3.1"),
		// 								}},
		// 								Value: to.Ptr("3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2"),
		// 								MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 									{
		// 										DisplayText: to.Ptr(".NET Core 2.2"),
		// 										StackSettings: &armappservice.FunctionAppRuntimes{
		// 											LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 												AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 													IsSupported: to.Ptr(true),
		// 												},
		// 												AppSettingsDictionary: map[string]*string{
		// 													"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 												},
		// 												GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 													IsSupported: to.Ptr(true),
		// 													SupportedVersion: to.Ptr("2.2.207"),
		// 												},
		// 												RemoteDebuggingSupported: to.Ptr(false),
		// 												RuntimeVersion: to.Ptr("dotnet|2.2"),
		// 												SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 													LinuxFxVersion: to.Ptr("dotnet|2.2"),
		// 													Use32BitWorkerProcess: to.Ptr(false),
		// 												},
		// 												SupportedFunctionsExtensionVersions: []*string{
		// 													to.Ptr("~2")},
		// 												},
		// 												WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 													AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 														IsSupported: to.Ptr(true),
		// 													},
		// 													AppSettingsDictionary: map[string]*string{
		// 														"FUNCTIONS_WORKER_RUNTIME": to.Ptr("dotnet"),
		// 													},
		// 													GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 														IsSupported: to.Ptr(true),
		// 														SupportedVersion: to.Ptr("2.2.207"),
		// 													},
		// 													RemoteDebuggingSupported: to.Ptr(false),
		// 													RuntimeVersion: to.Ptr("2.2"),
		// 													SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 														Use32BitWorkerProcess: to.Ptr(true),
		// 													},
		// 													SupportedFunctionsExtensionVersions: []*string{
		// 														to.Ptr("~2")},
		// 													},
		// 												},
		// 												Value: to.Ptr("2.2"),
		// 										}},
		// 										Value: to.Ptr("2"),
		// 									},
		// 									{
		// 										DisplayText: to.Ptr(".NET Framework 4"),
		// 										MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 											{
		// 												DisplayText: to.Ptr(".NET Framework 4.7"),
		// 												StackSettings: &armappservice.FunctionAppRuntimes{
		// 													WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 														AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 															IsSupported: to.Ptr(true),
		// 														},
		// 														AppSettingsDictionary: map[string]*string{
		// 														},
		// 														GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 															IsSupported: to.Ptr(false),
		// 														},
		// 														RemoteDebuggingSupported: to.Ptr(false),
		// 														RuntimeVersion: to.Ptr("4.7"),
		// 														SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 															Use32BitWorkerProcess: to.Ptr(true),
		// 														},
		// 														SupportedFunctionsExtensionVersions: []*string{
		// 															to.Ptr("~1")},
		// 														},
		// 													},
		// 													Value: to.Ptr("4.7"),
		// 											}},
		// 											Value: to.Ptr("2"),
		// 									}},
		// 									PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 									Value: to.Ptr("dotnet"),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("node"),
		// 								Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 								ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/node"),
		// 								Location: to.Ptr("westus"),
		// 								Properties: &armappservice.FunctionAppStackProperties{
		// 									DisplayText: to.Ptr("Node.js"),
		// 									MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 										{
		// 											DisplayText: to.Ptr("Node.js 14"),
		// 											MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 												{
		// 													DisplayText: to.Ptr("Node.js 14 LTS"),
		// 													StackSettings: &armappservice.FunctionAppRuntimes{
		// 														LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 															AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																IsSupported: to.Ptr(true),
		// 															},
		// 															AppSettingsDictionary: map[string]*string{
		// 																"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 															},
		// 															GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																IsSupported: to.Ptr(true),
		// 																SupportedVersion: to.Ptr("14.x"),
		// 															},
		// 															IsHidden: to.Ptr(true),
		// 															IsPreview: to.Ptr(true),
		// 															RemoteDebuggingSupported: to.Ptr(false),
		// 															RuntimeVersion: to.Ptr("Node|14"),
		// 															SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																LinuxFxVersion: to.Ptr("Node|14"),
		// 																Use32BitWorkerProcess: to.Ptr(false),
		// 															},
		// 															SupportedFunctionsExtensionVersions: []*string{
		// 																to.Ptr("~3")},
		// 															},
		// 															WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																	IsSupported: to.Ptr(true),
		// 																},
		// 																AppSettingsDictionary: map[string]*string{
		// 																	"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																	"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~14"),
		// 																},
		// 																GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																	IsSupported: to.Ptr(true),
		// 																	SupportedVersion: to.Ptr("14.x"),
		// 																},
		// 																IsHidden: to.Ptr(true),
		// 																IsPreview: to.Ptr(true),
		// 																RemoteDebuggingSupported: to.Ptr(false),
		// 																RuntimeVersion: to.Ptr("~14"),
		// 																SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																	Use32BitWorkerProcess: to.Ptr(true),
		// 																},
		// 																SupportedFunctionsExtensionVersions: []*string{
		// 																	to.Ptr("~3")},
		// 																},
		// 															},
		// 															Value: to.Ptr("14 LTS"),
		// 													}},
		// 													Value: to.Ptr("14"),
		// 												},
		// 												{
		// 													DisplayText: to.Ptr("Node.js 12"),
		// 													MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 														{
		// 															DisplayText: to.Ptr("Node.js 12 LTS"),
		// 															StackSettings: &armappservice.FunctionAppRuntimes{
		// 																LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																	AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																		IsSupported: to.Ptr(true),
		// 																	},
		// 																	AppSettingsDictionary: map[string]*string{
		// 																		"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																	},
		// 																	GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																		IsSupported: to.Ptr(true),
		// 																		SupportedVersion: to.Ptr("12.x"),
		// 																	},
		// 																	RemoteDebuggingSupported: to.Ptr(false),
		// 																	RuntimeVersion: to.Ptr("Node|12"),
		// 																	SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																		LinuxFxVersion: to.Ptr("Node|12"),
		// 																		Use32BitWorkerProcess: to.Ptr(false),
		// 																	},
		// 																	SupportedFunctionsExtensionVersions: []*string{
		// 																		to.Ptr("~3")},
		// 																	},
		// 																	WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																		AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																			IsSupported: to.Ptr(true),
		// 																		},
		// 																		AppSettingsDictionary: map[string]*string{
		// 																			"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																			"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~12"),
		// 																		},
		// 																		GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																			IsSupported: to.Ptr(true),
		// 																			SupportedVersion: to.Ptr("12.x"),
		// 																		},
		// 																		RemoteDebuggingSupported: to.Ptr(false),
		// 																		RuntimeVersion: to.Ptr("~12"),
		// 																		SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																			Use32BitWorkerProcess: to.Ptr(true),
		// 																		},
		// 																		SupportedFunctionsExtensionVersions: []*string{
		// 																			to.Ptr("~3")},
		// 																		},
		// 																	},
		// 																	Value: to.Ptr("12 LTS"),
		// 															}},
		// 															Value: to.Ptr("12"),
		// 														},
		// 														{
		// 															DisplayText: to.Ptr("Node.js 10"),
		// 															MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																{
		// 																	DisplayText: to.Ptr("Node.js 10 LTS"),
		// 																	StackSettings: &armappservice.FunctionAppRuntimes{
		// 																		LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																			AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																				IsSupported: to.Ptr(true),
		// 																			},
		// 																			AppSettingsDictionary: map[string]*string{
		// 																				"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																			},
		// 																			GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																				IsSupported: to.Ptr(true),
		// 																				SupportedVersion: to.Ptr("10.x"),
		// 																			},
		// 																			RemoteDebuggingSupported: to.Ptr(false),
		// 																			RuntimeVersion: to.Ptr("Node|10"),
		// 																			SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																				LinuxFxVersion: to.Ptr("Node|10"),
		// 																				Use32BitWorkerProcess: to.Ptr(false),
		// 																			},
		// 																			SupportedFunctionsExtensionVersions: []*string{
		// 																				to.Ptr("~2"),
		// 																				to.Ptr("~3")},
		// 																			},
		// 																			WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																				AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																					IsSupported: to.Ptr(true),
		// 																				},
		// 																				AppSettingsDictionary: map[string]*string{
		// 																					"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																					"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~10"),
		// 																				},
		// 																				GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																					IsSupported: to.Ptr(true),
		// 																					SupportedVersion: to.Ptr("10.x"),
		// 																				},
		// 																				RemoteDebuggingSupported: to.Ptr(false),
		// 																				RuntimeVersion: to.Ptr("~10"),
		// 																				SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																					Use32BitWorkerProcess: to.Ptr(true),
		// 																				},
		// 																				SupportedFunctionsExtensionVersions: []*string{
		// 																					to.Ptr("~2"),
		// 																					to.Ptr("~3")},
		// 																				},
		// 																			},
		// 																			Value: to.Ptr("10 LTS"),
		// 																	}},
		// 																	Value: to.Ptr("10"),
		// 																},
		// 																{
		// 																	DisplayText: to.Ptr("Node.js 8"),
		// 																	MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																		{
		// 																			DisplayText: to.Ptr("Node.js 8 LTS"),
		// 																			StackSettings: &armappservice.FunctionAppRuntimes{
		// 																				WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																					AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																						IsSupported: to.Ptr(true),
		// 																					},
		// 																					AppSettingsDictionary: map[string]*string{
		// 																						"FUNCTIONS_WORKER_RUNTIME": to.Ptr("node"),
		// 																						"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~8"),
		// 																					},
		// 																					GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																						IsSupported: to.Ptr(true),
		// 																						SupportedVersion: to.Ptr("8.x"),
		// 																					},
		// 																					RemoteDebuggingSupported: to.Ptr(false),
		// 																					RuntimeVersion: to.Ptr("~8"),
		// 																					SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																						Use32BitWorkerProcess: to.Ptr(true),
		// 																					},
		// 																					SupportedFunctionsExtensionVersions: []*string{
		// 																						to.Ptr("~2")},
		// 																					},
		// 																				},
		// 																				Value: to.Ptr("8 LTS"),
		// 																		}},
		// 																		Value: to.Ptr("8"),
		// 																	},
		// 																	{
		// 																		DisplayText: to.Ptr("Node.js 6"),
		// 																		MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																			{
		// 																				DisplayText: to.Ptr("Node.js 6 LTS"),
		// 																				StackSettings: &armappservice.FunctionAppRuntimes{
		// 																					WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																						AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																							IsSupported: to.Ptr(true),
		// 																						},
		// 																						AppSettingsDictionary: map[string]*string{
		// 																							"WEBSITE_NODE_DEFAULT_VERSION": to.Ptr("~6"),
		// 																						},
		// 																						GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																							IsSupported: to.Ptr(false),
		// 																						},
		// 																						RemoteDebuggingSupported: to.Ptr(false),
		// 																						RuntimeVersion: to.Ptr("~6"),
		// 																						SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																							Use32BitWorkerProcess: to.Ptr(true),
		// 																						},
		// 																						SupportedFunctionsExtensionVersions: []*string{
		// 																							to.Ptr("~1")},
		// 																						},
		// 																					},
		// 																					Value: to.Ptr("6 LTS"),
		// 																			}},
		// 																			Value: to.Ptr("6"),
		// 																	}},
		// 																	PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																	Value: to.Ptr("node"),
		// 																},
		// 															},
		// 															{
		// 																Name: to.Ptr("python"),
		// 																Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 																ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/python"),
		// 																Location: to.Ptr("westus"),
		// 																Properties: &armappservice.FunctionAppStackProperties{
		// 																	DisplayText: to.Ptr("Python"),
		// 																	MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																		{
		// 																			DisplayText: to.Ptr("Python 3"),
		// 																			MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																				{
		// 																					DisplayText: to.Ptr("Python 3.8"),
		// 																					StackSettings: &armappservice.FunctionAppRuntimes{
		// 																						LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																							AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																								IsSupported: to.Ptr(true),
		// 																							},
		// 																							AppSettingsDictionary: map[string]*string{
		// 																								"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																							},
		// 																							GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																								IsSupported: to.Ptr(true),
		// 																								SupportedVersion: to.Ptr("3.8"),
		// 																							},
		// 																							RemoteDebuggingSupported: to.Ptr(false),
		// 																							RuntimeVersion: to.Ptr("Python|3.8"),
		// 																							SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																								LinuxFxVersion: to.Ptr("Python|3.8"),
		// 																								Use32BitWorkerProcess: to.Ptr(false),
		// 																							},
		// 																							SupportedFunctionsExtensionVersions: []*string{
		// 																								to.Ptr("~3")},
		// 																							},
		// 																						},
		// 																						Value: to.Ptr("3.8"),
		// 																					},
		// 																					{
		// 																						DisplayText: to.Ptr("Python 3.7"),
		// 																						StackSettings: &armappservice.FunctionAppRuntimes{
		// 																							LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																								AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																									IsSupported: to.Ptr(true),
		// 																								},
		// 																								AppSettingsDictionary: map[string]*string{
		// 																									"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																								},
		// 																								GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																									IsSupported: to.Ptr(true),
		// 																									SupportedVersion: to.Ptr("3.7"),
		// 																								},
		// 																								RemoteDebuggingSupported: to.Ptr(false),
		// 																								RuntimeVersion: to.Ptr("Python|3.7"),
		// 																								SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																									LinuxFxVersion: to.Ptr("Python|3.7"),
		// 																									Use32BitWorkerProcess: to.Ptr(false),
		// 																								},
		// 																								SupportedFunctionsExtensionVersions: []*string{
		// 																									to.Ptr("~2"),
		// 																									to.Ptr("~3")},
		// 																								},
		// 																							},
		// 																							Value: to.Ptr("3.7"),
		// 																						},
		// 																						{
		// 																							DisplayText: to.Ptr("Python 3.6"),
		// 																							StackSettings: &armappservice.FunctionAppRuntimes{
		// 																								LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																									AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																										IsSupported: to.Ptr(true),
		// 																									},
		// 																									AppSettingsDictionary: map[string]*string{
		// 																										"FUNCTIONS_WORKER_RUNTIME": to.Ptr("python"),
		// 																									},
		// 																									GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																										IsSupported: to.Ptr(true),
		// 																										SupportedVersion: to.Ptr("3.6"),
		// 																									},
		// 																									RemoteDebuggingSupported: to.Ptr(false),
		// 																									RuntimeVersion: to.Ptr("Python|3.6"),
		// 																									SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																										LinuxFxVersion: to.Ptr("Python|3.6"),
		// 																										Use32BitWorkerProcess: to.Ptr(false),
		// 																									},
		// 																									SupportedFunctionsExtensionVersions: []*string{
		// 																										to.Ptr("~2"),
		// 																										to.Ptr("~3")},
		// 																									},
		// 																								},
		// 																								Value: to.Ptr("3.6"),
		// 																						}},
		// 																						Value: to.Ptr("3"),
		// 																				}},
		// 																				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 																				Value: to.Ptr("python"),
		// 																			},
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("java"),
		// 																			Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 																			ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/java"),
		// 																			Location: to.Ptr("westus"),
		// 																			Properties: &armappservice.FunctionAppStackProperties{
		// 																				DisplayText: to.Ptr("Java"),
		// 																				MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																					{
		// 																						DisplayText: to.Ptr("Java 11"),
		// 																						MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																							{
		// 																								DisplayText: to.Ptr("Java 11"),
		// 																								StackSettings: &armappservice.FunctionAppRuntimes{
		// 																									LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																											IsSupported: to.Ptr(true),
		// 																										},
		// 																										AppSettingsDictionary: map[string]*string{
		// 																											"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																										},
		// 																										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																											IsSupported: to.Ptr(true),
		// 																											SupportedVersion: to.Ptr("11"),
		// 																										},
		// 																										IsAutoUpdate: to.Ptr(true),
		// 																										RemoteDebuggingSupported: to.Ptr(false),
		// 																										RuntimeVersion: to.Ptr("Java|11"),
		// 																										SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																											LinuxFxVersion: to.Ptr("Java|11"),
		// 																											Use32BitWorkerProcess: to.Ptr(false),
		// 																										},
		// 																										SupportedFunctionsExtensionVersions: []*string{
		// 																											to.Ptr("~3")},
		// 																										},
		// 																										WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																											AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																												IsSupported: to.Ptr(true),
		// 																											},
		// 																											AppSettingsDictionary: map[string]*string{
		// 																												"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																											},
		// 																											GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																												IsSupported: to.Ptr(true),
		// 																												SupportedVersion: to.Ptr("11"),
		// 																											},
		// 																											IsAutoUpdate: to.Ptr(true),
		// 																											RemoteDebuggingSupported: to.Ptr(false),
		// 																											RuntimeVersion: to.Ptr("11"),
		// 																											SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																												JavaVersion: to.Ptr("11"),
		// 																												Use32BitWorkerProcess: to.Ptr(true),
		// 																											},
		// 																											SupportedFunctionsExtensionVersions: []*string{
		// 																												to.Ptr("~3")},
		// 																											},
		// 																										},
		// 																										Value: to.Ptr("11.0"),
		// 																								}},
		// 																								Value: to.Ptr("11"),
		// 																							},
		// 																							{
		// 																								DisplayText: to.Ptr("Java 8"),
		// 																								MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																									{
		// 																										DisplayText: to.Ptr("Java 8"),
		// 																										StackSettings: &armappservice.FunctionAppRuntimes{
		// 																											LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																												AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																													IsSupported: to.Ptr(true),
		// 																												},
		// 																												AppSettingsDictionary: map[string]*string{
		// 																													"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																												},
		// 																												GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																													IsSupported: to.Ptr(true),
		// 																													SupportedVersion: to.Ptr("8"),
		// 																												},
		// 																												IsAutoUpdate: to.Ptr(true),
		// 																												IsDefault: to.Ptr(true),
		// 																												RemoteDebuggingSupported: to.Ptr(false),
		// 																												RuntimeVersion: to.Ptr("Java|8"),
		// 																												SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																													LinuxFxVersion: to.Ptr("Java|8"),
		// 																													Use32BitWorkerProcess: to.Ptr(false),
		// 																												},
		// 																												SupportedFunctionsExtensionVersions: []*string{
		// 																													to.Ptr("~3")},
		// 																												},
		// 																												WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																													AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																														IsSupported: to.Ptr(true),
		// 																													},
		// 																													AppSettingsDictionary: map[string]*string{
		// 																														"FUNCTIONS_WORKER_RUNTIME": to.Ptr("java"),
		// 																													},
		// 																													GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																														IsSupported: to.Ptr(true),
		// 																														SupportedVersion: to.Ptr("8"),
		// 																													},
		// 																													IsAutoUpdate: to.Ptr(true),
		// 																													IsDefault: to.Ptr(true),
		// 																													RemoteDebuggingSupported: to.Ptr(false),
		// 																													RuntimeVersion: to.Ptr("1.8"),
		// 																													SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																														JavaVersion: to.Ptr("1.8"),
		// 																														Use32BitWorkerProcess: to.Ptr(true),
		// 																													},
		// 																													SupportedFunctionsExtensionVersions: []*string{
		// 																														to.Ptr("~2"),
		// 																														to.Ptr("~3")},
		// 																													},
		// 																												},
		// 																												Value: to.Ptr("8.0"),
		// 																										}},
		// 																										Value: to.Ptr("8"),
		// 																								}},
		// 																								PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																								Value: to.Ptr("java"),
		// 																							},
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("powershell"),
		// 																							Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 																							ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/powershell"),
		// 																							Location: to.Ptr("westus"),
		// 																							Properties: &armappservice.FunctionAppStackProperties{
		// 																								DisplayText: to.Ptr("PowerShell Core"),
		// 																								MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																									{
		// 																										DisplayText: to.Ptr("PowerShell 7"),
		// 																										MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																											{
		// 																												DisplayText: to.Ptr("PowerShell 7.0"),
		// 																												StackSettings: &armappservice.FunctionAppRuntimes{
		// 																													WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																														AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																															IsSupported: to.Ptr(true),
		// 																														},
		// 																														AppSettingsDictionary: map[string]*string{
		// 																															"FUNCTIONS_WORKER_RUNTIME": to.Ptr("powershell"),
		// 																														},
		// 																														GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																															IsSupported: to.Ptr(false),
		// 																														},
		// 																														RemoteDebuggingSupported: to.Ptr(false),
		// 																														RuntimeVersion: to.Ptr("~7"),
		// 																														SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																															PowerShellVersion: to.Ptr("~7"),
		// 																															Use32BitWorkerProcess: to.Ptr(true),
		// 																														},
		// 																														SupportedFunctionsExtensionVersions: []*string{
		// 																															to.Ptr("~3")},
		// 																														},
		// 																													},
		// 																													Value: to.Ptr("7.0"),
		// 																											}},
		// 																											Value: to.Ptr("7"),
		// 																										},
		// 																										{
		// 																											DisplayText: to.Ptr("PowerShell Core 6"),
		// 																											MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																												{
		// 																													DisplayText: to.Ptr("PowerShell Core 6.2"),
		// 																													StackSettings: &armappservice.FunctionAppRuntimes{
		// 																														WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																															AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																IsSupported: to.Ptr(true),
		// 																															},
		// 																															AppSettingsDictionary: map[string]*string{
		// 																																"FUNCTIONS_WORKER_RUNTIME": to.Ptr("powershell"),
		// 																															},
		// 																															EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-04T00:00:00.000Z"); return t}()),
		// 																															GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																IsSupported: to.Ptr(false),
		// 																															},
		// 																															IsDeprecated: to.Ptr(true),
		// 																															RemoteDebuggingSupported: to.Ptr(false),
		// 																															RuntimeVersion: to.Ptr("~6"),
		// 																															SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																PowerShellVersion: to.Ptr("~6"),
		// 																																Use32BitWorkerProcess: to.Ptr(true),
		// 																															},
		// 																															SupportedFunctionsExtensionVersions: []*string{
		// 																																to.Ptr("~2"),
		// 																																to.Ptr("~3")},
		// 																															},
		// 																														},
		// 																														Value: to.Ptr("6.2"),
		// 																												}},
		// 																												Value: to.Ptr("6"),
		// 																										}},
		// 																										PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																										Value: to.Ptr("powershell"),
		// 																									},
		// 																								},
		// 																								{
		// 																									Name: to.Ptr("custom"),
		// 																									Type: to.Ptr("Microsoft.Web/locations/functionAppStacks"),
		// 																									ID: to.Ptr("/providers/Microsoft.Web/locations/functionAppStacks/custom"),
		// 																									Location: to.Ptr("westus"),
		// 																									Properties: &armappservice.FunctionAppStackProperties{
		// 																										DisplayText: to.Ptr("Custom"),
		// 																										MajorVersions: []*armappservice.FunctionAppMajorVersion{
		// 																											{
		// 																												DisplayText: to.Ptr("Custom"),
		// 																												MinorVersions: []*armappservice.FunctionAppMinorVersion{
		// 																													{
		// 																														DisplayText: to.Ptr("Custom Handler"),
		// 																														StackSettings: &armappservice.FunctionAppRuntimes{
		// 																															LinuxRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																																AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																	IsSupported: to.Ptr(true),
		// 																																},
		// 																																AppSettingsDictionary: map[string]*string{
		// 																																	"FUNCTIONS_WORKER_RUNTIME": to.Ptr("custom"),
		// 																																},
		// 																																GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																	IsSupported: to.Ptr(false),
		// 																																},
		// 																																IsPreview: to.Ptr(true),
		// 																																RemoteDebuggingSupported: to.Ptr(false),
		// 																																RuntimeVersion: to.Ptr(""),
		// 																																SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																	LinuxFxVersion: to.Ptr(""),
		// 																																	Use32BitWorkerProcess: to.Ptr(false),
		// 																																},
		// 																																SupportedFunctionsExtensionVersions: []*string{
		// 																																	to.Ptr("~3"),
		// 																																	to.Ptr("~2")},
		// 																																},
		// 																																WindowsRuntimeSettings: &armappservice.FunctionAppRuntimeSettings{
		// 																																	AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 																																		IsSupported: to.Ptr(true),
		// 																																	},
		// 																																	AppSettingsDictionary: map[string]*string{
		// 																																		"FUNCTIONS_WORKER_RUNTIME": to.Ptr("custom"),
		// 																																	},
		// 																																	GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 																																		IsSupported: to.Ptr(false),
		// 																																	},
		// 																																	IsPreview: to.Ptr(true),
		// 																																	RemoteDebuggingSupported: to.Ptr(false),
		// 																																	RuntimeVersion: to.Ptr("custom"),
		// 																																	SiteConfigPropertiesDictionary: &armappservice.SiteConfigPropertiesDictionary{
		// 																																		Use32BitWorkerProcess: to.Ptr(true),
		// 																																	},
		// 																																	SupportedFunctionsExtensionVersions: []*string{
		// 																																		to.Ptr("~3"),
		// 																																		to.Ptr("~2")},
		// 																																	},
		// 																																},
		// 																																Value: to.Ptr("custom"),
		// 																														}},
		// 																														Value: to.Ptr("custom"),
		// 																												}},
		// 																												PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 																												Value: to.Ptr("custom"),
		// 																											},
		// 																									}},
		// 																								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebAppStacksForLocation.json
func ExampleProviderClient_NewGetWebAppStacksForLocationPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderClient().NewGetWebAppStacksForLocationPager("westus", &armappservice.ProviderClientGetWebAppStacksForLocationOptions{StackOsType: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppStackCollection = armappservice.WebAppStackCollection{
		// 	Value: []*armappservice.WebAppStack{
		// 		{
		// 			Name: to.Ptr("dotnet"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/dotnet"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr(".NET"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr(".NET 5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET 5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("5.0.x"),
		// 										},
		// 										IsEarlyAccess: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|5.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("5.0.x"),
		// 										},
		// 										IsEarlyAccess: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v5.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("5"),
		// 						}},
		// 						Value: to.Ptr("5"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.1 (LTS)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|3.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-03T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.0.103"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|3.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-03T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.0.103"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.0"),
		// 						}},
		// 						Value: to.Ptr("3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-23T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.2.207"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.2"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-23T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.2.207"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.1 (LTS)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-21T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.807"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-21T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.807"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.202"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.202"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.0"),
		// 						}},
		// 						Value: to.Ptr("dotnetcore2"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 1"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 1.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|1.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 1.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|1.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.0"),
		// 						}},
		// 						Value: to.Ptr("1"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("ASP.NET V4"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("ASP.NET V4.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v4.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("v4.8"),
		// 						}},
		// 						Value: to.Ptr("v4"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("ASP.NET V3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("ASP.NET V3.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v2.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("v3.5"),
		// 						}},
		// 						Value: to.Ptr("v3"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 				Value: to.Ptr("dotnet"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("node"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/node"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Node"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Node LTS"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("lts"),
		// 						}},
		// 						Value: to.Ptr("lts"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 14"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 14 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("14.x"),
		// 										},
		// 										IsPreview: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|14-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14-lts"),
		// 						}},
		// 						Value: to.Ptr("14"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 12"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 12 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("12.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|12-lts"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("12.13.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("12-lts"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 12.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("12.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(true),
		// 										RuntimeVersion: to.Ptr("NODE|12.9"),
		// 									},
		// 								},
		// 								Value: to.Ptr("12.9"),
		// 						}},
		// 						Value: to.Ptr("12"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 10"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 10 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10-LTS"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.16"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.16"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.16"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.15"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsHidden: to.Ptr(true),
		// 										IsPreview: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.15.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.15"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.14"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.14.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.10"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.0.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.6.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.1"),
		// 						}},
		// 						Value: to.Ptr("10"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 9"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 9.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|9.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.4"),
		// 						}},
		// 						Value: to.Ptr("9"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 8"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 8 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8-lts"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.11"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.11"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.10"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.9"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.9"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.9"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.1.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 						}},
		// 						Value: to.Ptr("8"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 7.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.10.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.10"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 6"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 6 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6-LTS"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.11"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.10"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.9"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.9.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.9"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.5.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.2"),
		// 						}},
		// 						Value: to.Ptr("6"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 4"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 4.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.8"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("4.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 4.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 4.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.4"),
		// 						}},
		// 						Value: to.Ptr("4"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("node"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("python"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/python"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Python"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Python 3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Python 3.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Python 3.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.7"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Python 3.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.6"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.6"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.4.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.6"),
		// 						}},
		// 						Value: to.Ptr("3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Python 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Python 2.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.7"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|2.7"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.7"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.7.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.7"),
		// 						}},
		// 						Value: to.Ptr("2"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("python"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("php"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/php"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("PHP"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("PHP 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-28T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.4"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-28T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-06T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.3"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-06T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.2"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("7.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("PHP 5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("PHP 5.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|5.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("5.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("5.6"),
		// 						}},
		// 						Value: to.Ptr("5"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("php"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ruby"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/ruby"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Ruby"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Ruby 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.6.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.6.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.6.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.5.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.5.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.5.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.4.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.4.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.4.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3.3"),
		// 						}},
		// 						Value: to.Ptr("2"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("ruby"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("java"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/java"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Java"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Java 11"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.5_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.3_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.2_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.2"),
		// 						}},
		// 						Value: to.Ptr("11"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Java 8"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_252"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_252"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.252"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_242"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_232"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_232_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.232"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_212"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_212_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.212"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_202"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_202_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.202"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_202 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_202"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.202 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_181"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_181_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.181"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_181 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_181"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.181 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_172"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_172_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.172"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_172 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_172"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.172 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_144"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_144"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.144"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_111 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_111"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.111 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_102"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_102"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.102"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_92"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_92"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.92"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_73 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_73"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.73 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_60 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_60"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.60 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_25 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_25"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.25 (Oracle)"),
		// 						}},
		// 						Value: to.Ptr("8"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Java 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_262"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_262_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.262"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_242_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_222"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_222_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.222"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_191"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_191_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.191"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_80 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_80"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.80 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_71 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_71"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.71 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_51 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_51"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.51 (Oracle)"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("java"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("javacontainers"),
		// 			Type: to.Ptr("Microsoft.Web/locations/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/locations/webAppStacks/javacontainers"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Java Containers"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Java SE (Embedded Web Server)"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java SE (Embedded Web Server)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("JAVA|11-java11"),
		// 										Java8Runtime: to.Ptr("JAVA|8-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JAVA"),
		// 										JavaContainerVersion: to.Ptr("SE"),
		// 									},
		// 								},
		// 								Value: to.Ptr("SE"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u252"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u252"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.252"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u242"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u232"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u232"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.232"),
		// 						}},
		// 						Value: to.Ptr("javase"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("JBoss EAP"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("JBoss EAP 7.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsPreview: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("JBOSSEAP|7.2-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.2"),
		// 						}},
		// 						Value: to.Ptr("jbosseap"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 9.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.37"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.37-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.37-java8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.37"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.37"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.33"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.33-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.33-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.33"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.31"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.31"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.31"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.27"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.27"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.27"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.21"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.21"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.21"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.20"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.20-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.20-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.20"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.14"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.0"),
		// 						}},
		// 						Value: to.Ptr("tomcat9.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 8.5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.57"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.57-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.57-java8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.57"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.57"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.53"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.53-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.53-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.53"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.51"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.51"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.51"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.47"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.47"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.47"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.42"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.42"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.42"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.41"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.41-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.41-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.41"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.37"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.37"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.37"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.34"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.34"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.34"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.31"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.31"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.31"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.20"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.20"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.20"),
		// 						}},
		// 						Value: to.Ptr("tomcat8.5"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 8.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.53"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.53"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.53"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.46"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.46"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.46"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.23"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.23"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.23"),
		// 						}},
		// 						Value: to.Ptr("tomcat8.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 7.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.94"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.94"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.94"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.81"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.81"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.81"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.62"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.62"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.62"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.50"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.50"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.50"),
		// 						}},
		// 						Value: to.Ptr("tomcat7.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Jetty 9.3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3.25"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3.25"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3.25"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3.13"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3.13"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3.13"),
		// 						}},
		// 						Value: to.Ptr("jetty9.3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Jetty 9.1"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.1.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.1.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.1.0"),
		// 						}},
		// 						Value: to.Ptr("jetty9.1"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("WildFly 14"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("WildFly 14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("WILDFLY|14-jre8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("WildFly 14.0.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("WILDFLY|14.0.1-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14.0.1"),
		// 						}},
		// 						Value: to.Ptr("wildfly14"),
		// 				}},
		// 				Value: to.Ptr("javacontainers"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListOperations.json
func ExampleProviderClient_NewListOperationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderClient().NewListOperationsPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CsmOperationCollection = armappservice.CsmOperationCollection{
		// 	Value: []*armappservice.CsmOperationDescription{
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a Web App"),
		// 				Operation: to.Ptr("Get Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new Web App or update an existing one"),
		// 				Operation: to.Ptr("Create or Update Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new Web App Slot or update an existing one"),
		// 				Operation: to.Ptr("Create or Update Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an existing Web App"),
		// 				Operation: to.Ptr("Delete Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an existing Web App Slot"),
		// 				Operation: to.Ptr("Delete Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/config/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web App Slot's configuration settings"),
		// 				Operation: to.Ptr("Get Web App Slot Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/config/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web App configuration settings"),
		// 				Operation: to.Ptr("Get Web App Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/config/list/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Web App's security sensitive settings, such as publishing credentials, app settings and connection strings"),
		// 				Operation: to.Ptr("List Web App Security Sensitive Settings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/config/list/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Web App Slot's security sensitive settings, such as publishing credentials, app settings and connection strings"),
		// 				Operation: to.Ptr("List Web App Slot Security Sensitive Settings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/config/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web App's configuration settings"),
		// 				Operation: to.Ptr("Update Web App Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/config/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web App Slot's configuration settings"),
		// 				Operation: to.Ptr("Update Web App Slot Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/sourcecontrols/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web App's source control configuration settings"),
		// 				Operation: to.Ptr("Get Web App Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/sourcecontrols/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web App Slot's source control configuration settings"),
		// 				Operation: to.Ptr("Get Web App Slot Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/sourcecontrols/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web App's source control configuration settings"),
		// 				Operation: to.Ptr("Update Web App Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/sourcecontrols/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web App Slot's source control configuration settings"),
		// 				Operation: to.Ptr("Update Web App Slot Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/sourcecontrols/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web App's source control configuration settings"),
		// 				Operation: to.Ptr("Delete Web App Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/sourcecontrols/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web App Slot's source control configuration settings"),
		// 				Operation: to.Ptr("Delete Web App Slot Source Control Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/backup/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new web app backup"),
		// 				Operation: to.Ptr("Create Web App Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/backup/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create new Web App Slot backup."),
		// 				Operation: to.Ptr("Create Web App Slot Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/backups/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a web app's backup"),
		// 				Operation: to.Ptr("Get Web App Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/backups/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a web app slots' backup"),
		// 				Operation: to.Ptr("List Web App Slot Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/publishxml/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get publishing profile xml for a Web App"),
		// 				Operation: to.Ptr("Get Web App Publishing Profile"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/publishxml/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get publishing profile xml for Web App Slot"),
		// 				Operation: to.Ptr("Get Web App Slot Publishing Profile"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/publish/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Publish a Web App"),
		// 				Operation: to.Ptr("Publish Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/publish/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Publish a Web App Slot"),
		// 				Operation: to.Ptr("Publish Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/restart/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restart a Web App"),
		// 				Operation: to.Ptr("Restart Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/restart/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restart a Web App Slot"),
		// 				Operation: to.Ptr("Restart Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/start/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Start a Web App"),
		// 				Operation: to.Ptr("Start Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/start/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Start a Web App Slot"),
		// 				Operation: to.Ptr("Start Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/stop/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Stop a Web App"),
		// 				Operation: to.Ptr("Stop Web App"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/stop/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Stop a Web App Slot"),
		// 				Operation: to.Ptr("Stop Web App Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slotsswap/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Swap Web App deployment slots"),
		// 				Operation: to.Ptr("Swap Web App Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/slotsswap/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Swap Web App deployment slots"),
		// 				Operation: to.Ptr("Swap Web App Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slotsdiffs/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get differences in configuration between web app and slots"),
		// 				Operation: to.Ptr("Get Web App Slots Differences"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/slotsdiffs/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get differences in configuration between web app and slots"),
		// 				Operation: to.Ptr("Get Web App Slots Differences"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/applySlotConfig/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Apply web app slot configuration from target slot to the current web app"),
		// 				Operation: to.Ptr("Apply Web App Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/applySlotConfig/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Apply web app slot configuration from target slot to the current slot."),
		// 				Operation: to.Ptr("Apply Web App Slot Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/resetSlotConfig/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Reset web app configuration"),
		// 				Operation: to.Ptr("Reset Web App Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/resetSlotConfig/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Reset web app slot configuration"),
		// 				Operation: to.Ptr("Reset Web App Slot Configuration"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a Web App deployment slot"),
		// 				Operation: to.Ptr("Get Web App Deployment Slot"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/serverfarms/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties on an App Service Plan"),
		// 				Operation: to.Ptr("Get App Service Plan"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plan"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/serverfarms/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new App Service Plan or update an existing one"),
		// 				Operation: to.Ptr("Create or Update App Service Plan"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plan"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/serverfarms/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an existing App Service Plan"),
		// 				Operation: to.Ptr("Delete App Service Plan"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plan"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/serverfarms/restartSites/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restart all Web Apps in an App Service Plan"),
		// 				Operation: to.Ptr("Restart Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plan"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/certificates/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of certificates."),
		// 				Operation: to.Ptr("Get Certificates"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Certificate"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/certificates/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Add a new certificate or update an existing one."),
		// 				Operation: to.Ptr("Add or Update Certificate"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Certificate"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/certificates/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an existing certificate."),
		// 				Operation: to.Ptr("Delete Certificate"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Certificate"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/aseRegions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of ASE regions."),
		// 				Operation: to.Ptr("Get ASE Regions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("ASE Region"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/geoRegions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of Geo regions."),
		// 				Operation: to.Ptr("Get Geo Regions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Geo Region"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/listSitesAssignedToHostName/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get names of sites assigned to hostname."),
		// 				Operation: to.Ptr("Get sites assigned to hostname"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Site Name"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of an App Service Environment"),
		// 				Operation: to.Ptr("Get App Service Environment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new App Service Environment or update existing one"),
		// 				Operation: to.Ptr("Create or Update App Service Environment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an App Service Environment"),
		// 				Operation: to.Ptr("Delete App Service Environment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/reboot/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Reboot all machines in an App Service Environment"),
		// 				Operation: to.Ptr("Reboot an App Service Environment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a FrontEnd Pool in an App Service Environment"),
		// 				Operation: to.Ptr("Get FrontEnd Pool"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment FrontEnd Pool"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new FrontEnd Pool in an App Service Environment or update an existing one"),
		// 				Operation: to.Ptr("Create or Update FrontEnd Pool"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment FrontEnd Pool"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the properties of a Worker Pool in an App Service Environment"),
		// 				Operation: to.Ptr("Get Worker Pool"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment Worker Pool"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Create a new Worker Pool in an App Service Environment or update an existing one"),
		// 				Operation: to.Ptr("Create or Update Worker Pool"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Environment Worker Pool"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connections/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of Connections."),
		// 				Operation: to.Ptr("Get Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connections/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates a Connection."),
		// 				Operation: to.Ptr("Add or Update Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connections/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Deletes a Connection."),
		// 				Operation: to.Ptr("Delete Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connections/Join/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Joins a Connection."),
		// 				Operation: to.Ptr("Join Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connectionGateways/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of Connection Gateways."),
		// 				Operation: to.Ptr("Get Connection Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connection Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connectionGateways/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates a Connection Gateway."),
		// 				Operation: to.Ptr("Add or Update Connection Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connection Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connectionGateways/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Deletes a Connection Gateway."),
		// 				Operation: to.Ptr("Delete Connection Gateway"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connection Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/connectionGateways/Join/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Joins a Connection Gateway."),
		// 				Operation: to.Ptr("Join Connection Gateway"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connection Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/recommendations/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of recommendations for subscriptions."),
		// 				Operation: to.Ptr("Get recommendations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Recommendation"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/recommendations/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of recommendations for web app."),
		// 				Operation: to.Ptr("Get recommendations for web app"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Recommendation"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/availablestacks/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Available Stacks."),
		// 				Operation: to.Ptr("Get Available Stacks"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Available Stacks"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/functionappstacks/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Function App Stacks."),
		// 				Operation: to.Ptr("Get Function App Stacks"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Function App Stacks"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/webappstacks/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web App Stacks."),
		// 				Operation: to.Ptr("Get Web App Stacks"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web App Stacks"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/checknameavailability/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Check if resource name is available."),
		// 				Operation: to.Ptr("Get Check Name Availability"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Check Name Availability"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/classicmobileservices/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Classic Mobile Services."),
		// 				Operation: to.Ptr("Get Classic Mobile Services"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Classic Mobile Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/connections/confirmconsentcode/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Confirm Connections Consent Code."),
		// 				Operation: to.Ptr("Confirm Connections Consent Code"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/connections/listconsentlinks/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Consent Links for Connections."),
		// 				Operation: to.Ptr("List Consent Links for Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/deploymentlocations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Deployment Locations."),
		// 				Operation: to.Ptr("Get Deployment Locations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Deployment Locations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/capacities/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Capacities."),
		// 				Operation: to.Ptr("Get Hosting Environments Capacities"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Capacities"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/diagnostics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Diagnostics."),
		// 				Operation: to.Ptr("Get Hosting Environments Diagnostics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Diagnostics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Metric Definitions."),
		// 				Operation: to.Ptr("Get Hosting Environments Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/multirolepools/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments MultiRole Pools Metric Definitions."),
		// 				Operation: to.Ptr("Get Hosting Environments MultiRole Pools Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments MultiRole Pools Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/multirolepools/metrics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments MultiRole Pools Metrics."),
		// 				Operation: to.Ptr("Get Hosting Environments MultiRole Pools Metrics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments MultiRole Pools Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/multirolepools/skus/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments MultiRole Pools SKUs."),
		// 				Operation: to.Ptr("Get Hosting Environments MultiRole Pools SKUs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments MultiRole Pools SKUs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/multirolepools/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments MultiRole Pools Usages."),
		// 				Operation: to.Ptr("Get Hosting Environments MultiRole Pools Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments MultiRole Pools Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/operations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Operations."),
		// 				Operation: to.Ptr("Get Hosting Environments Operations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/resume/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Resume Hosting Environments."),
		// 				Operation: to.Ptr("Resume Hosting Environments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/serverfarms/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments App Service Plans."),
		// 				Operation: to.Ptr("Get Hosting Environments App Service Plans"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments App Service Plans"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/sites/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Web Apps."),
		// 				Operation: to.Ptr("Get Hosting Environments Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/suspend/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Suspend Hosting Environments."),
		// 				Operation: to.Ptr("Suspend Hosting Environments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Usages."),
		// 				Operation: to.Ptr("Get Hosting Environments Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/workerpools/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Workerpools Metric Definitions."),
		// 				Operation: to.Ptr("Get Hosting Environments Workerpools Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Workerpools Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/workerpools/metrics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Workerpools Metrics."),
		// 				Operation: to.Ptr("Get Hosting Environments Workerpools Metrics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Workerpools Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/workerpools/skus/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Workerpools SKUs."),
		// 				Operation: to.Ptr("Get Hosting Environments Workerpools SKUs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Workerpools SKUs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/workerpools/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Hosting Environments Workerpools Usages."),
		// 				Operation: to.Ptr("Get Hosting Environments Workerpools Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environments Workerpools Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/ishostingenvironmentnameavailable/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get if Hosting Environment Name is available."),
		// 				Operation: to.Ptr("Check if Hosting Environment Name is available"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hosting Environment Name"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/ishostnameavailable/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Check if Hostname is Available."),
		// 				Operation: to.Ptr("Check if Hostname is Available"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Hostname"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/isusernameavailable/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Check if Username is available."),
		// 				Operation: to.Ptr("Check if Username is available"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Username"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/locations/apioperations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Locations API Operations."),
		// 				Operation: to.Ptr("Get Locations API Operations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Locations API Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/locations/connectiongatewayinstallations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Locations Connection Gateway Installations."),
		// 				Operation: to.Ptr("Get Locations Connection Gateway Installations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Locations Connection Gateway Installations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/locations/functionappstacks/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Locations Function App Stacks."),
		// 				Operation: to.Ptr("Get Locations Function App Stacks"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Locations Function App Stacks"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/locations/webappstacks/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Locations Web App Stacks."),
		// 				Operation: to.Ptr("Get Locations Web App Stacks"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Locations Web App Stacks"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/locations/managedapis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Locations Managed APIs."),
		// 				Operation: to.Ptr("Get Locations Managed APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Locations Managed APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/operations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Operations."),
		// 				Operation: to.Ptr("Get Operations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/publishingusers/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Publishing Users."),
		// 				Operation: to.Ptr("Get Publishing Users"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Publishing Users"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/publishingusers/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Publishing Users."),
		// 				Operation: to.Ptr("Update Publishing Users"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Publishing Users"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/capabilities/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Capabilities."),
		// 				Operation: to.Ptr("Get App Service Plans Capabilities"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Capabilities"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/firstpartyapps/settings/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete App Service Plans First Party Apps Settings."),
		// 				Operation: to.Ptr("Delete App Service Plans First Party Apps Settings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans First Party Apps Settings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/firstpartyapps/settings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans First Party Apps Settings."),
		// 				Operation: to.Ptr("Get App Service Plans First Party Apps Settings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans First Party Apps Settings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/firstpartyapps/settings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update App Service Plans First Party Apps Settings."),
		// 				Operation: to.Ptr("Update App Service Plans First Party Apps Settings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans First Party Apps Settings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/hybridconnectionnamespaces/relays/sites/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Hybrid Connection Namespaces Relays Web Apps."),
		// 				Operation: to.Ptr("Get App Service Plans Hybrid Connection Namespaces Relays Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Hybrid Connection Namespaces Relays Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/hybridconnectionplanlimits/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Hybrid Connection Plan Limits."),
		// 				Operation: to.Ptr("Get App Service Plans Hybrid Connection Plan Limits"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Hybrid Connection Plan Limits"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/hybridconnectionrelays/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Hybrid Connection Relays."),
		// 				Operation: to.Ptr("Get App Service Plans Hybrid Connection Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Hybrid Connection Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Metric Definitions."),
		// 				Operation: to.Ptr("Get App Service Plans Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/metrics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Metrics."),
		// 				Operation: to.Ptr("Get App Service Plans Metrics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/operationresults/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Operation Results."),
		// 				Operation: to.Ptr("Get App Service Plans Operation Results"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Operation Results"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/sites/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Web Apps."),
		// 				Operation: to.Ptr("Get App Service Plans Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/skus/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans SKUs."),
		// 				Operation: to.Ptr("Get App Service Plans SKUs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans SKUs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Usages."),
		// 				Operation: to.Ptr("Get App Service Plans Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/virtualnetworkconnections/gateways/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update App Service Plans Virtual Network Connections Gateways."),
		// 				Operation: to.Ptr("Update App Service Plans Virtual Network Connections Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Virtual Network Connections Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/virtualnetworkconnections/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Virtual Network Connections."),
		// 				Operation: to.Ptr("Get App Service Plans Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/virtualnetworkconnections/routes/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete App Service Plans Virtual Network Connections Routes."),
		// 				Operation: to.Ptr("Delete App Service Plans Virtual Network Connections Routes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Virtual Network Connections Routes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/virtualnetworkconnections/routes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Virtual Network Connections Routes."),
		// 				Operation: to.Ptr("Get App Service Plans Virtual Network Connections Routes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Virtual Network Connections Routes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/virtualnetworkconnections/routes/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update App Service Plans Virtual Network Connections Routes."),
		// 				Operation: to.Ptr("Update App Service Plans Virtual Network Connections Routes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Virtual Network Connections Routes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/workers/reboot/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Reboot App Service Plans Workers."),
		// 				Operation: to.Ptr("Reboot App Service Plans Workers"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Workers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/analyzecustomhostname/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Analyze Custom Hostname."),
		// 				Operation: to.Ptr("Analyze Custom Hostname"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Custom Hostname"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/backup/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Backup."),
		// 				Operation: to.Ptr("Get Web Apps Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Backup"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/backup/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Backup."),
		// 				Operation: to.Ptr("Update Web Apps Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Backup"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/backups/list/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Web Apps Backups."),
		// 				Operation: to.Ptr("List Web Apps Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/backups/restore/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restore Web Apps Backups."),
		// 				Operation: to.Ptr("Restore Web Apps Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/config/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Config."),
		// 				Operation: to.Ptr("Delete Web Apps Config"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Config"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/continuouswebjobs/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Continuous Web Jobs."),
		// 				Operation: to.Ptr("Delete Web Apps Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/continuouswebjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Continuous Web Jobs."),
		// 				Operation: to.Ptr("Get Web Apps Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/continuouswebjobs/start/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Start Web Apps Continuous Web Jobs."),
		// 				Operation: to.Ptr("Start Web Apps Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/continuouswebjobs/stop/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Stop Web Apps Continuous Web Jobs."),
		// 				Operation: to.Ptr("Stop Web Apps Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/deployments/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Deployments."),
		// 				Operation: to.Ptr("Delete Web Apps Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/deployments/log/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Deployments Log."),
		// 				Operation: to.Ptr("Get Web Apps Deployments Log"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Deployments Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/deployments/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Deployments."),
		// 				Operation: to.Ptr("Update Web Apps Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/frebanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics FREB Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics FREB Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics FREB Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/frebanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics FREB Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics FREB Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics FREB Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Categories."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Category"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Category"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/runtimeavailability/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Runtime Availability."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Runtime Availability"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Runtime Availability"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/servicehealth/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Service Health."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Service Health"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Service Health"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/workeravailability/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Workeravailability."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Workeravailability"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Workeravailability"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/workeravailability/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Workeravailability."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Workeravailability"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Workeravailability"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/workerprocessrecycle/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Worker Process Recycle."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Worker Process Recycle"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Worker Process Recycle"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/workerprocessrecycle/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Worker Process Recycle."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Worker Process Recycle"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Worker Process Recycle"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/aspnetcore/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics for ASP.NET Core app."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics ASP.NET Core"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics ASP.NET Core"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/aspnetcore/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics for ASP.NET Core app."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics ASP.NET Core"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics ASP.NET Core"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/domainownershipidentifiers/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Domain Ownership Identifiers."),
		// 				Operation: to.Ptr("Get Web Apps Domain Ownership Identifiers"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Domain Ownership Identifiers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/domainownershipidentifiers/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Domain Ownership Identifiers."),
		// 				Operation: to.Ptr("Update Web Apps Domain Ownership Identifiers"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Domain Ownership Identifiers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Functions Web Apps."),
		// 				Operation: to.Ptr("Functions Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Functions."),
		// 				Operation: to.Ptr("Delete Web Apps Functions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/listsecrets/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Secrets Web Apps Functions."),
		// 				Operation: to.Ptr("List Secrets Web Apps Functions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Functions."),
		// 				Operation: to.Ptr("Get Web Apps Functions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Functions."),
		// 				Operation: to.Ptr("Update Web Apps Functions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hostnamebindings/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Hostname Bindings."),
		// 				Operation: to.Ptr("Delete Web Apps Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hostnamebindings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Hostname Bindings."),
		// 				Operation: to.Ptr("Get Web Apps Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hostnamebindings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Hostname Bindings."),
		// 				Operation: to.Ptr("Update Web Apps Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnection/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Hybrid Connection."),
		// 				Operation: to.Ptr("Delete Web Apps Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnection/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Hybrid Connection."),
		// 				Operation: to.Ptr("Get Web Apps Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnection/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Hybrid Connection."),
		// 				Operation: to.Ptr("Update Web Apps Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnectionrelays/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Hybrid Connection Relays."),
		// 				Operation: to.Ptr("Get Web Apps Hybrid Connection Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Instances Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Instances Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/processes/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Instances Processes."),
		// 				Operation: to.Ptr("Delete Web Apps Instances Processes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Processes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/processes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Instances Processes."),
		// 				Operation: to.Ptr("Get Web Apps Instances Processes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Processes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Instances."),
		// 				Operation: to.Ptr("Get Web Apps Instances"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/listsyncfunctiontriggerstatus/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Sync Function Trigger Status Web Apps."),
		// 				Operation: to.Ptr("List Sync Function Trigger Status Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Metric Definitions."),
		// 				Operation: to.Ptr("Get Web Apps Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/metrics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Metrics."),
		// 				Operation: to.Ptr("Get Web Apps Metrics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/networktrace/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Network Trace Web Apps."),
		// 				Operation: to.Ptr("Network Trace Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/newpassword/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Newpassword Web Apps."),
		// 				Operation: to.Ptr("Newpassword Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/operationresults/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Operation Results."),
		// 				Operation: to.Ptr("Get Web Apps Operation Results"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Operation Results"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/perfcounters/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Performance Counters."),
		// 				Operation: to.Ptr("Get Web Apps Performance Counters"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Performance Counters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/premieraddons/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Premier Addons."),
		// 				Operation: to.Ptr("Delete Web Apps Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/premieraddons/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Premier Addons."),
		// 				Operation: to.Ptr("Get Web Apps Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/premieraddons/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Premier Addons."),
		// 				Operation: to.Ptr("Update Web Apps Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/publishxml/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Publishing XML."),
		// 				Operation: to.Ptr("Get Web Apps Publishing XML"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Publishing XML"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/recommendationhistory/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Recommendation History."),
		// 				Operation: to.Ptr("Get Web Apps Recommendation History"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Recommendation History"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/recommendations/disable/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Disable Web Apps Recommendations."),
		// 				Operation: to.Ptr("Disable Web Apps Recommendations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Recommendations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/restore/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Restore."),
		// 				Operation: to.Ptr("Get Web Apps Restore"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Restore"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/analyzecustomhostname/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Analyze Custom Hostname."),
		// 				Operation: to.Ptr("Get Web Apps Slots Analyze Custom Hostname"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Analyze Custom Hostname"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/backup/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Backup."),
		// 				Operation: to.Ptr("Update Web Apps Slots Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Backup"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/backups/list/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Web Apps Slots Backups."),
		// 				Operation: to.Ptr("List Web Apps Slots Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/backups/restore/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restore Web Apps Slots Backups."),
		// 				Operation: to.Ptr("Restore Web Apps Slots Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/config/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Config."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Config"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Config"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/continuouswebjobs/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Continuous Web Jobs."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/continuouswebjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Continuous Web Jobs."),
		// 				Operation: to.Ptr("Get Web Apps Slots Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/continuouswebjobs/start/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Start Web Apps Slots Continuous Web Jobs."),
		// 				Operation: to.Ptr("Start Web Apps Slots Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/continuouswebjobs/stop/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Stop Web Apps Slots Continuous Web Jobs."),
		// 				Operation: to.Ptr("Stop Web Apps Slots Continuous Web Jobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Continuous Web Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/deployments/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Deployments."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/deployments/log/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Deployments Log."),
		// 				Operation: to.Ptr("Get Web Apps Slots Deployments Log"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Deployments Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Slots Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/deployments/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Deployments."),
		// 				Operation: to.Ptr("Update Web Apps Slots Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hostnamebindings/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Hostname Bindings."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hostnamebindings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Hostname Bindings."),
		// 				Operation: to.Ptr("Get Web Apps Slots Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hostnamebindings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Hostname Bindings."),
		// 				Operation: to.Ptr("Update Web Apps Slots Hostname Bindings"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hostname Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnection/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Hybrid Connection."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnection/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Hybrid Connection."),
		// 				Operation: to.Ptr("Get Web Apps Slots Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnection/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Hybrid Connection."),
		// 				Operation: to.Ptr("Update Web Apps Slots Hybrid Connection"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/instances/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Instances Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Slots Instances Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Instances Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/instances/processes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Instances Processes."),
		// 				Operation: to.Ptr("Get Web Apps Slots Instances Processes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Instances Processes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/instances/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Instances."),
		// 				Operation: to.Ptr("Get Web Apps Slots Instances"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Instances"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/metricdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Metric Definitions."),
		// 				Operation: to.Ptr("Get Web Apps Slots Metric Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Metric Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/metrics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Metrics."),
		// 				Operation: to.Ptr("Get Web Apps Slots Metrics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/newpassword/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Newpassword Web Apps Slots."),
		// 				Operation: to.Ptr("Newpassword Web Apps Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/operationresults/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Operation Results."),
		// 				Operation: to.Ptr("Get Web Apps Slots Operation Results"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Operation Results"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/phplogging/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Phplogging."),
		// 				Operation: to.Ptr("Get Web Apps Slots Phplogging"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Phplogging"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/premieraddons/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Premier Addons."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/premieraddons/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Premier Addons."),
		// 				Operation: to.Ptr("Get Web Apps Slots Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/premieraddons/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Premier Addons."),
		// 				Operation: to.Ptr("Update Web Apps Slots Premier Addons"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Premier Addons"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/restore/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Restore."),
		// 				Operation: to.Ptr("Get Web Apps Slots Restore"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Restore"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/sync/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Sync Web Apps Slots."),
		// 				Operation: to.Ptr("Sync Web Apps Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/triggeredwebjobs/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Triggered WebJobs."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/triggeredwebjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Triggered WebJobs."),
		// 				Operation: to.Ptr("Get Web Apps Slots Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/triggeredwebjobs/run/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Slots Triggered WebJobs."),
		// 				Operation: to.Ptr("Run Web Apps Slots Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Usages."),
		// 				Operation: to.Ptr("Get Web Apps Slots Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/virtualnetworkconnections/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Virtual Network Connections."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/virtualnetworkconnections/gateways/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Virtual Network Connections Gateways."),
		// 				Operation: to.Ptr("Update Web Apps Slots Virtual Network Connections Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Virtual Network Connections Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/virtualnetworkconnections/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Virtual Network Connections."),
		// 				Operation: to.Ptr("Get Web Apps Slots Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/virtualnetworkconnections/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Virtual Network Connections."),
		// 				Operation: to.Ptr("Update Web Apps Slots Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/webjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots WebJobs."),
		// 				Operation: to.Ptr("Get Web Apps Slots WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/snapshots/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Snapshots."),
		// 				Operation: to.Ptr("Get Web Apps Snapshots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Snapshots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/sync/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Sync Web Apps."),
		// 				Operation: to.Ptr("Sync Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/triggeredwebjobs/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Triggered WebJobs."),
		// 				Operation: to.Ptr("Delete Web Apps Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/triggeredwebjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Triggered WebJobs."),
		// 				Operation: to.Ptr("Get Web Apps Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/triggeredwebjobs/run/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Triggered WebJobs."),
		// 				Operation: to.Ptr("Run Web Apps Triggered WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Triggered WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/usages/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Usages."),
		// 				Operation: to.Ptr("Get Web Apps Usages"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Usages"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/virtualnetworkconnections/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Virtual Network Connections."),
		// 				Operation: to.Ptr("Delete Web Apps Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/virtualnetworkconnections/gateways/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Virtual Network Connections Gateways."),
		// 				Operation: to.Ptr("Get Web Apps Virtual Network Connections Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Virtual Network Connections Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/virtualnetworkconnections/gateways/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Virtual Network Connections Gateways."),
		// 				Operation: to.Ptr("Update Web Apps Virtual Network Connections Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Virtual Network Connections Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/virtualnetworkconnections/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Virtual Network Connections."),
		// 				Operation: to.Ptr("Get Web Apps Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/virtualnetworkconnections/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Virtual Network Connections."),
		// 				Operation: to.Ptr("Update Web Apps Virtual Network Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Virtual Network Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/webjobs/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps WebJobs."),
		// 				Operation: to.Ptr("Get Web Apps WebJobs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps WebJobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/skus/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get SKUs."),
		// 				Operation: to.Ptr("Get SKUs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("SKUs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sourcecontrols/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Source Controls."),
		// 				Operation: to.Ptr("Get Source Controls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Source Controls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sourcecontrols/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Source Controls."),
		// 				Operation: to.Ptr("Update Source Controls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Source Controls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/unregister/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Unregister Microsoft.Web resource provider for the subscription."),
		// 				Operation: to.Ptr("Unregister Microsoft.Web resource provider"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Microsoft.Web resource provider"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/validate/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Validate ."),
		// 				Operation: to.Ptr("Validate "),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr(""),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/register/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Register Microsoft.Web resource provider for the subscription."),
		// 				Operation: to.Ptr("Register Microsoft.Web resource provider"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Microsoft.Web resource provider"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/hybridconnectionnamespaces/relays/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get App Service Plans Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Get App Service Plans Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/backups/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Backups."),
		// 				Operation: to.Ptr("Delete Web Apps Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnectionnamespaces/relays/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Delete Web Apps Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnectionnamespaces/relays/listkeys/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Keys Web Apps Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("List Keys Web Apps Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnectionnamespaces/relays/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Update Web Apps Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/metricsdefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Metrics Definitions."),
		// 				Operation: to.Ptr("Get Web Apps Metrics Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Metrics Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/migratemysql/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Migrate MySql Web Apps."),
		// 				Operation: to.Ptr("Migrate MySql Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/migratemysql/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Migrate MySql."),
		// 				Operation: to.Ptr("Get Web Apps Migrate MySql"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Migrate MySql"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/recover/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Recover Web Apps."),
		// 				Operation: to.Ptr("Recover Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/siteextensions/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Site Extensions."),
		// 				Operation: to.Ptr("Delete Web Apps Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/siteextensions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Site Extensions."),
		// 				Operation: to.Ptr("Get Web Apps Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/siteextensions/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Site Extensions."),
		// 				Operation: to.Ptr("Update Web Apps Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/backup/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Backup."),
		// 				Operation: to.Ptr("Get Web Apps Slots Backup"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Backup"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnectionrelays/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Hybrid Connection Relays."),
		// 				Operation: to.Ptr("Get Web Apps Slots Hybrid Connection Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/siteextensions/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Site Extensions."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/siteextensions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Site Extensions."),
		// 				Operation: to.Ptr("Get Web Apps Slots Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/siteextensions/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Site Extensions."),
		// 				Operation: to.Ptr("Update Web Apps Slots Site Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Site Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/snapshots/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Snapshots."),
		// 				Operation: to.Ptr("Get Web Apps Slots Snapshots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Snapshots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/syncfunctiontriggers/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Sync Function Triggers for Web Apps."),
		// 				Operation: to.Ptr("Sync Function Triggers for Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/triggeredwebjobs/history/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Triggered WebJobs History."),
		// 				Operation: to.Ptr("Get Web Apps Triggered WebJobs History"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Triggered WebJobs History"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/connectiongateways/liststatus/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Status Connection Gateways."),
		// 				Operation: to.Ptr("List Status Connection Gateways"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Connection Gateways"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/hybridconnectionnamespaces/relays/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete App Service Plans Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Delete App Service Plans Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("App Service Plans Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/deployment/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Deployment."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Deployment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Deployment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/sitecpuanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site CPU Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site CPU Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site CPU Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/sitelatency/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Latency."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Latency"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Latency"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/sitememoryanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Memory Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Memory Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Memory Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/threadcount/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Thread Count."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Thread Count"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Thread Count"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/deployment/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Deployment."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Deployment"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Deployment"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/sitecpuanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site CPU Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site CPU Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site CPU Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/sitelatency/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Latency."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Latency"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Latency"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/sitememoryanalysis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Memory Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Memory Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Memory Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/threadcount/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Thread Count."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Thread Count"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Thread Count"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/masterkey/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Functions Masterkey."),
		// 				Operation: to.Ptr("Get Web Apps Functions Masterkey"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions Masterkey"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/hybridconnectionnamespaces/relays/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Get Web Apps Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/extensions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Instances Extensions."),
		// 				Operation: to.Ptr("Get Web Apps Instances Extensions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/operations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Operations."),
		// 				Operation: to.Ptr("Get Web Apps Operations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/resourcehealthmetadata/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Resource Health Metadata."),
		// 				Operation: to.Ptr("Get Web Apps Resource Health Metadata"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Resource Health Metadata"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/backups/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Backups."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Backups"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Backups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/domainownershipidentifiers/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Domain Ownership Identifiers."),
		// 				Operation: to.Ptr("Get Web Apps Slots Domain Ownership Identifiers"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Domain Ownership Identifiers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnectionnamespaces/relays/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/hybridconnectionnamespaces/relays/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Slots Hybrid Connection Namespaces Relays."),
		// 				Operation: to.Ptr("Update Web Apps Slots Hybrid Connection Namespaces Relays"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Hybrid Connection Namespaces Relays"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/operations/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Operations."),
		// 				Operation: to.Ptr("Get Web Apps Slots Operations"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/perfcounters/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Performance Counters."),
		// 				Operation: to.Ptr("Get Web Apps Slots Performance Counters"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Performance Counters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/resourcehealthmetadata/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Resource Health Metadata."),
		// 				Operation: to.Ptr("Get Web Apps Slots Resource Health Metadata"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Resource Health Metadata"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apiacls/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts Apiacls."),
		// 				Operation: to.Ptr("Get Api Management Accounts Apiacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts Apiacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/connectionacls/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts Connectionacls."),
		// 				Operation: to.Ptr("Get Api Management Accounts Connectionacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts Connectionacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/apiacls/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Api Management Accounts APIs Apiacls."),
		// 				Operation: to.Ptr("Delete Api Management Accounts APIs Apiacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Apiacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/apiacls/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs Apiacls."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs Apiacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Apiacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/apiacls/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Api Management Accounts APIs Apiacls."),
		// 				Operation: to.Ptr("Update Api Management Accounts APIs Apiacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Apiacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connectionacls/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs Connectionacls."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs Connectionacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connectionacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/confirmconsentcode/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Confirm Consent Code Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("Confirm Consent Code Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/connectionacls/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Api Management Accounts APIs Connections Connectionacls."),
		// 				Operation: to.Ptr("Delete Api Management Accounts APIs Connections Connectionacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections Connectionacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/connectionacls/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs Connections Connectionacls."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs Connections Connectionacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections Connectionacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/connectionacls/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Api Management Accounts APIs Connections Connectionacls."),
		// 				Operation: to.Ptr("Update Api Management Accounts APIs Connections Connectionacls"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections Connectionacls"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("Delete Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/getconsentlinks/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Consent Links for Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("Get Consent Links for Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("Update Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Api Management Accounts APIs."),
		// 				Operation: to.Ptr("Delete Api Management Accounts APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/localizeddefinitions/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Api Management Accounts APIs Localized Definitions."),
		// 				Operation: to.Ptr("Delete Api Management Accounts APIs Localized Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Localized Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/localizeddefinitions/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Api Management Accounts APIs Localized Definitions."),
		// 				Operation: to.Ptr("Get Api Management Accounts APIs Localized Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Localized Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/localizeddefinitions/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Api Management Accounts APIs Localized Definitions."),
		// 				Operation: to.Ptr("Update Api Management Accounts APIs Localized Definitions"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Localized Definitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Api Management Accounts APIs."),
		// 				Operation: to.Ptr("Update Api Management Accounts APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/listconnectionkeys/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Connection Keys Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("List Connection Keys Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/apimanagementaccounts/apis/connections/listsecrets/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("List Secrets Api Management Accounts APIs Connections."),
		// 				Operation: to.Ptr("List Secrets Api Management Accounts APIs Connections"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Api Management Accounts APIs Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/deployments/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Deployments."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/loganalyzer/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Log Analyzer."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Log Analyzer"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Log Analyzer"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/loganalyzer/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Log Analyzer."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Log Analyzer"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Log Analyzer"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/sitecrashes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Crashes."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Crashes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Crashes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/sitecrashes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Crashes."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Crashes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Crashes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/siterestartsettingupdate/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Restart Setting Update."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Restart Setting Update"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Restart Setting Update"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/siterestartsettingupdate/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Restart Setting Update."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Restart Setting Update"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Restart Setting Update"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/siterestartuserinitiated/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Restart User Initiated."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Restart User Initiated"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Restart User Initiated"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/siterestartuserinitiated/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Restart User Initiated."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Restart User Initiated"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Restart User Initiated"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/siteswap/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Site Swap."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Site Swap"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Site Swap"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/siteswap/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Swap."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Swap"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Swap"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/functions/token/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Functions Token."),
		// 				Operation: to.Ptr("Get Web Apps Functions Token"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Functions Token"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/deployments/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Instances Deployments."),
		// 				Operation: to.Ptr("Delete Web Apps Instances Deployments"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/processes/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Processes."),
		// 				Operation: to.Ptr("Get Web Apps Processes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Processes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/publiccertificates/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Public Certificates."),
		// 				Operation: to.Ptr("Delete Web Apps Public Certificates"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Public Certificates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/publiccertificates/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Public Certificates."),
		// 				Operation: to.Ptr("Get Web Apps Public Certificates"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Public Certificates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/publiccertificates/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Web Apps Public Certificates."),
		// 				Operation: to.Ptr("Update Web Apps Public Certificates"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Public Certificates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/networktrace/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Network Trace Web Apps Slots."),
		// 				Operation: to.Ptr("Network Trace Web Apps Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/autoheal/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Autoheal."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Autoheal"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Autoheal"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/autoheal/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Autoheal."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Autoheal"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Autoheal"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/runtimeavailability/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Runtime Availability."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Runtime Availability"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Runtime Availability"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/servicehealth/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Service Health."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Service Health"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Service Health"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/sitelatency/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Site Latency."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Site Latency"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Site Latency"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/migratemysql/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Migrate MySql."),
		// 				Operation: to.Ptr("Get Web Apps Slots Migrate MySql"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Migrate MySql"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for Web App"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for Web App"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for Web App slot"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for Web App slot"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for App Service plan"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/serverfarms/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for App Service plan"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/hostingenvironments/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Diagnostic setting for App Service Environment"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/billingmeters/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get list of billing meters."),
		// 				Operation: to.Ptr("Read billing meters"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Billing meters for Microsoft Web Apps"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/instances/processes/delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete Web Apps Slots Instances Processes."),
		// 				Operation: to.Ptr("Delete Web Apps Slots Instances Processes"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Instances Processes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/restore/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restore Web Apps."),
		// 				Operation: to.Ptr("Restore Web Apps"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/instances/extensions/log/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Instances Extensions Log."),
		// 				Operation: to.Ptr("Get Web Apps Instances Extensions Log"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Instances Extensions Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/customapis/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Update Custom APIs."),
		// 				Operation: to.Ptr("Update Custom APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Custom APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/customapis/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Custom APIs."),
		// 				Operation: to.Ptr("Get Custom APIs"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Custom APIs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/failedrequestsperuri/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Failed Requests Per Uri."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Failed Requests Per Uri"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Failed Requests Per Uri"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/restore/write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Restore Web Apps Slots."),
		// 				Operation: to.Ptr("Restore Web Apps Slots"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/detectors/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Detector."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Detector"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Detector"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/analyses/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Diagnostics Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Diagnostics Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/analyses/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Analysis."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/detectors/read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get Web Apps Slots Diagnostics Detector."),
		// 				Operation: to.Ptr("Get Web Apps Slots Diagnostics Detector"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Detector"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/analyses/execute/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Diagnostics Analysis."),
		// 				Operation: to.Ptr("Run Web Apps Diagnostics Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/diagnostics/detectors/execute/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Diagnostics Detector."),
		// 				Operation: to.Ptr("Run Web Apps Diagnostics Detector"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Diagnostics Detector"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/analyses/execute/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Slots Diagnostics Analysis."),
		// 				Operation: to.Ptr("Run Web Apps Slots Diagnostics Analysis"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Analysis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("microsoft.web/sites/slots/diagnostics/detectors/execute/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Run Web Apps Slots Diagnostics Detector."),
		// 				Operation: to.Ptr("Run Web Apps Slots Diagnostics Detector"),
		// 				Provider: to.Ptr("Microsoft Web Apps"),
		// 				Resource: to.Ptr("Web Apps Slots Diagnostics Detector"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/serverfarms/providers/Microsoft.Insights/metricDefinitions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for App Service Plan"),
		// 				Operation: to.Ptr("Read App Service Plan metric definitions"),
		// 				Provider: to.Ptr("Microsoft.Web"),
		// 				Resource: to.Ptr("The metric definition of App Service Plan"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armappservice.CsmOperationDescriptionProperties{
		// 				ServiceSpecification: &armappservice.ServiceSpecification{
		// 					MetricSpecifications: []*armappservice.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("CpuPercentage"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("CPU Percentage"),
		// 							DisplayName: to.Ptr("CPU Percentage"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Percent"),
		// 						},
		// 						{
		// 							Name: to.Ptr("MemoryPercentage"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Memory Percentage"),
		// 							DisplayName: to.Ptr("Memory Percentage"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Percent"),
		// 						},
		// 						{
		// 							Name: to.Ptr("DiskQueueLength"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Disk Queue Length"),
		// 							DisplayName: to.Ptr("Disk Queue Length"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("HttpQueueLength"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http Queue Length"),
		// 							DisplayName: to.Ptr("Http Queue Length"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesReceived"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data In"),
		// 							DisplayName: to.Ptr("Data In"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesSent"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data Out"),
		// 							DisplayName: to.Ptr("Data Out"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/providers/Microsoft.Insights/metricDefinitions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for Web App"),
		// 				Operation: to.Ptr("Read Web App metric definitions"),
		// 				Provider: to.Ptr("Microsoft.Web"),
		// 				Resource: to.Ptr("The metric definition of Web App"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armappservice.CsmOperationDescriptionProperties{
		// 				ServiceSpecification: &armappservice.ServiceSpecification{
		// 					MetricSpecifications: []*armappservice.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("CpuTime"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("CPU Time"),
		// 							DisplayName: to.Ptr("CPU Time"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Seconds"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Requests"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Requests"),
		// 							DisplayName: to.Ptr("Requests"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesReceived"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data In"),
		// 							DisplayName: to.Ptr("Data In"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesSent"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data Out"),
		// 							DisplayName: to.Ptr("Data Out"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http101"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 101"),
		// 							DisplayName: to.Ptr("Http 101"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http2xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 2xx"),
		// 							DisplayName: to.Ptr("Http 2xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http3xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 3xx"),
		// 							DisplayName: to.Ptr("Http 3xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http401"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 401"),
		// 							DisplayName: to.Ptr("Http 401"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http403"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 403"),
		// 							DisplayName: to.Ptr("Http 403"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http404"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 404"),
		// 							DisplayName: to.Ptr("Http 404"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http406"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 406"),
		// 							DisplayName: to.Ptr("Http 406"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http4xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 4xx"),
		// 							DisplayName: to.Ptr("Http 4xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http5xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http Server Errors"),
		// 							DisplayName: to.Ptr("Http Server Errors"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("MemoryWorkingSet"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Memory working set"),
		// 							DisplayName: to.Ptr("Memory working set"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("AverageMemoryWorkingSet"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Average memory working set"),
		// 							DisplayName: to.Ptr("Average memory working set"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("AverageResponseTime"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Average Response Time"),
		// 							DisplayName: to.Ptr("Average Response Time"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Seconds"),
		// 						},
		// 						{
		// 							Name: to.Ptr("FunctionExecutionUnits"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Function Execution Units"),
		// 							DisplayName: to.Ptr("Function Execution Units"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("(?i:functionapp)"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("FunctionExecutionCount"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Function Execution Count"),
		// 							DisplayName: to.Ptr("Function Execution Count"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("(?i:functionapp)"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/sites/slots/providers/Microsoft.Insights/metricDefinitions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for Web App Slot"),
		// 				Operation: to.Ptr("Read Web App Slot metric definitions"),
		// 				Provider: to.Ptr("Microsoft.Web"),
		// 				Resource: to.Ptr("The metric definition of Web App Slot"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armappservice.CsmOperationDescriptionProperties{
		// 				ServiceSpecification: &armappservice.ServiceSpecification{
		// 					MetricSpecifications: []*armappservice.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("CpuTime"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("CPU Time"),
		// 							DisplayName: to.Ptr("CPU Time"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Seconds"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Requests"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Requests"),
		// 							DisplayName: to.Ptr("Requests"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesReceived"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data In"),
		// 							DisplayName: to.Ptr("Data In"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesSent"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data Out"),
		// 							DisplayName: to.Ptr("Data Out"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http101"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 101"),
		// 							DisplayName: to.Ptr("Http 101"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http2xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 2xx"),
		// 							DisplayName: to.Ptr("Http 2xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http3xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 3xx"),
		// 							DisplayName: to.Ptr("Http 3xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http401"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 401"),
		// 							DisplayName: to.Ptr("Http 401"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http403"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 403"),
		// 							DisplayName: to.Ptr("Http 403"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http404"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 404"),
		// 							DisplayName: to.Ptr("Http 404"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http406"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 406"),
		// 							DisplayName: to.Ptr("Http 406"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http4xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 4xx"),
		// 							DisplayName: to.Ptr("Http 4xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http5xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http Server Errors"),
		// 							DisplayName: to.Ptr("Http Server Errors"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("MemoryWorkingSet"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Memory working set"),
		// 							DisplayName: to.Ptr("Memory working set"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("AverageMemoryWorkingSet"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Average memory working set"),
		// 							DisplayName: to.Ptr("Average memory working set"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("AverageResponseTime"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Average Response Time"),
		// 							DisplayName: to.Ptr("Average Response Time"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("^(?!functionapp).*$"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Seconds"),
		// 						},
		// 						{
		// 							Name: to.Ptr("FunctionExecutionUnits"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Function Execution Units"),
		// 							DisplayName: to.Ptr("Function Execution Units"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("(?i:functionapp)"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("FunctionExecutionCount"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Function Execution Count"),
		// 							DisplayName: to.Ptr("Function Execution Count"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							MetricFilterPattern: to.Ptr("(?i:functionapp)"),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools/providers/Microsoft.Insights/metricDefinitions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for App Service Environment MultiRole"),
		// 				Operation: to.Ptr("Read App Service Environment MultiRole metric definitions"),
		// 				Provider: to.Ptr("Microsoft.Web"),
		// 				Resource: to.Ptr("The metric definition of App Service Environment MultiRole"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armappservice.CsmOperationDescriptionProperties{
		// 				ServiceSpecification: &armappservice.ServiceSpecification{
		// 					MetricSpecifications: []*armappservice.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("Requests"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Requests"),
		// 							DisplayName: to.Ptr("Requests"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesReceived"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data In"),
		// 							DisplayName: to.Ptr("Data In"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("BytesSent"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Data Out"),
		// 							DisplayName: to.Ptr("Data Out"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Bytes"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http101"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 101"),
		// 							DisplayName: to.Ptr("Http 101"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http2xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 2xx"),
		// 							DisplayName: to.Ptr("Http 2xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http3xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 3xx"),
		// 							DisplayName: to.Ptr("Http 3xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http401"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 401"),
		// 							DisplayName: to.Ptr("Http 401"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http403"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 403"),
		// 							DisplayName: to.Ptr("Http 403"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http404"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 404"),
		// 							DisplayName: to.Ptr("Http 404"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http406"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 406"),
		// 							DisplayName: to.Ptr("Http 406"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http4xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http 4xx"),
		// 							DisplayName: to.Ptr("Http 4xx"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Http5xx"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http Server Errors"),
		// 							DisplayName: to.Ptr("Http Server Errors"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("AverageResponseTime"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Average Response Time"),
		// 							DisplayName: to.Ptr("Average Response Time"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Seconds"),
		// 						},
		// 						{
		// 							Name: to.Ptr("CpuPercentage"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("CPU Percentage"),
		// 							DisplayName: to.Ptr("CPU Percentage"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Percent"),
		// 						},
		// 						{
		// 							Name: to.Ptr("MemoryPercentage"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Memory Percentage"),
		// 							DisplayName: to.Ptr("Memory Percentage"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Percent"),
		// 						},
		// 						{
		// 							Name: to.Ptr("DiskQueueLength"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Disk Queue Length"),
		// 							DisplayName: to.Ptr("Disk Queue Length"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("HttpQueueLength"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Http Queue Length"),
		// 							DisplayName: to.Ptr("Http Queue Length"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("ActiveRequests"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Dimensions: []*armappservice.Dimension{
		// 								{
		// 									Name: to.Ptr("Instance"),
		// 									DisplayName: to.Ptr("Instance"),
		// 									InternalName: to.Ptr("ServerName"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayDescription: to.Ptr("Active Requests"),
		// 							DisplayName: to.Ptr("Active Requests"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("TotalFrontEnds"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Total Front Ends"),
		// 							DisplayName: to.Ptr("Total Front Ends"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("SmallAppServicePlanInstances"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Small App Service Plan Workers"),
		// 							DisplayName: to.Ptr("Small App Service Plan Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("MediumAppServicePlanInstances"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Medium App Service Plan Workers"),
		// 							DisplayName: to.Ptr("Medium App Service Plan Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("LargeAppServicePlanInstances"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Large App Service Plan Workers"),
		// 							DisplayName: to.Ptr("Large App Service Plan Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools/providers/Microsoft.Insights/metricDefinitions/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for App Service Environment WorkerPool"),
		// 				Operation: to.Ptr("Read App Service Environment WorkerPool metric definitions"),
		// 				Provider: to.Ptr("Microsoft.Web"),
		// 				Resource: to.Ptr("The metric definition of App Service Environment WorkerPool"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armappservice.CsmOperationDescriptionProperties{
		// 				ServiceSpecification: &armappservice.ServiceSpecification{
		// 					MetricSpecifications: []*armappservice.MetricSpecification{
		// 						{
		// 							Name: to.Ptr("WorkersTotal"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Total Workers"),
		// 							DisplayName: to.Ptr("Total Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("WorkersAvailable"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Available Workers"),
		// 							DisplayName: to.Ptr("Available Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("WorkersUsed"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Availabilities: []*armappservice.MetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P2D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P30D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									BlobDuration: to.Ptr("P90D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Used Workers"),
		// 							DisplayName: to.Ptr("Used Workers"),
		// 							EnableRegionalMdmAccount: to.Ptr(false),
		// 							FillGapWithZero: to.Ptr(true),
		// 							IsInternal: to.Ptr(false),
		// 							SupportsInstanceLevelAggregation: to.Ptr(false),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebAppStacks.json
func ExampleProviderClient_NewGetWebAppStacksPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderClient().NewGetWebAppStacksPager(&armappservice.ProviderClientGetWebAppStacksOptions{StackOsType: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppStackCollection = armappservice.WebAppStackCollection{
		// 	Value: []*armappservice.WebAppStack{
		// 		{
		// 			Name: to.Ptr("dotnet"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/dotnet"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr(".NET"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr(".NET 5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET 5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("5.0.x"),
		// 										},
		// 										IsEarlyAccess: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|5.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("5.0.x"),
		// 										},
		// 										IsEarlyAccess: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v5.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("5"),
		// 						}},
		// 						Value: to.Ptr("5"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.1 (LTS)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|3.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1.301"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 3.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-03T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.0.103"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|3.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-03T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.0.103"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.0"),
		// 						}},
		// 						Value: to.Ptr("3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-23T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.2.207"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.2"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-23T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.2.207"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.1 (LTS)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-21T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.807"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-21T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.807"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 2.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.202"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|2.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1.202"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.0"),
		// 						}},
		// 						Value: to.Ptr("dotnetcore2"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr(".NET Core 1"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 1.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|1.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr(".NET Core 1.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("DOTNETCORE|1.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-27T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("1.1.14"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.0"),
		// 						}},
		// 						Value: to.Ptr("1"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("ASP.NET V4"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("ASP.NET V4.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.1"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v4.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("v4.8"),
		// 						}},
		// 						Value: to.Ptr("v4"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("ASP.NET V3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("ASP.NET V3.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.1"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("v2.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("v3.5"),
		// 						}},
		// 						Value: to.Ptr("v3"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsWindows),
		// 				Value: to.Ptr("dotnet"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("node"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/node"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Node"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Node LTS"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("lts"),
		// 						}},
		// 						Value: to.Ptr("lts"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 14"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 14 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("14.x"),
		// 										},
		// 										IsPreview: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|14-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14-lts"),
		// 						}},
		// 						Value: to.Ptr("14"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 12"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 12 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("12.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|12-lts"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("12.13.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("12-lts"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 12.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("12.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(true),
		// 										RuntimeVersion: to.Ptr("NODE|12.9"),
		// 									},
		// 								},
		// 								Value: to.Ptr("12.9"),
		// 						}},
		// 						Value: to.Ptr("12"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 10"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 10 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10-LTS"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.16"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.16"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.16"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.15"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsHidden: to.Ptr(true),
		// 										IsPreview: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.15.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.15"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.14"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.14.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.10"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.0.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("10.6.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 10.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("10.x"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|10.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("10.1"),
		// 						}},
		// 						Value: to.Ptr("10"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 9"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 9.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|9.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.4"),
		// 						}},
		// 						Value: to.Ptr("9"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 8"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 8 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8-lts"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.11"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.11"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.10"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.9"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.9"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.9"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.1"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("8.1.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 8.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-31T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|8.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 						}},
		// 						Value: to.Ptr("8"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 7.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.10.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.10"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 6"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 6 LTS"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6-lts"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6-LTS"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.11"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.10"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.10"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.10"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.9"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.9"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.9.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.9"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("6.5.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 6.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|6.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("6.2"),
		// 						}},
		// 						Value: to.Ptr("6"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Node 4"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Node 4.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.8"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("4.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 4.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Node 4.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("NODE|4.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("4.4"),
		// 						}},
		// 						Value: to.Ptr("4"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("node"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("python"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/python"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Python"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Python 3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Python 3.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Python 3.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.7"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Python 3.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.6"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|3.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("3.6"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("3.4.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("3.6"),
		// 						}},
		// 						Value: to.Ptr("3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Python 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Python 2.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.7"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PYTHON|2.7"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("2.7"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("2.7.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.7"),
		// 						}},
		// 						Value: to.Ptr("2"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("python"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("php"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/php"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("PHP"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("PHP 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-28T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.4"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-28T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-06T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.3"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-06T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.2"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-30T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("PHP 7.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("7.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|7.0"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("7.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("PHP 5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("PHP 5.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("PHP|5.6"),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("5.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("5.6"),
		// 						}},
		// 						Value: to.Ptr("5"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("php"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ruby"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/ruby"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Ruby"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Ruby 2"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.6.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.6.2"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.6.2"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.5.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.5.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.5.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.4"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.4"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.4"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.4.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.4.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.4.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Ruby 2.3.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("RUBY|2.3.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("2.3.3"),
		// 						}},
		// 						Value: to.Ptr("2"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("ruby"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("java"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/java"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Java"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Java 11"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 11"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.5_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.3_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 11.0.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2026-10-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("11"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("11.0.2_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.2"),
		// 						}},
		// 						Value: to.Ptr("11"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Java 8"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_252"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_252"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.252"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_242"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_232"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr(""),
		// 									},
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_232_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.232"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_212"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_212_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.212"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_202"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_202_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.202"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_202 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_202"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.202 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_181"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_181_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.181"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_181 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_181"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.181 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_172"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_172_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.172"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_172 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_172"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.172 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_144"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_144"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.144"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_111 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_111"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.111 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_102"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_102"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.102"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_92"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2025-04-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_92"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.92"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_73 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_73"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.73 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_60 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_60"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.60 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.8.0_25 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(true),
		// 											SupportedVersion: to.Ptr("8"),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.8.0_25"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.25 (Oracle)"),
		// 						}},
		// 						Value: to.Ptr("8"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Java 7"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java 7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_262"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_262_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.262"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_242_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_222"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_222_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.222"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_191"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										EndOfLifeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-01T00:00:00.000Z"); return t}()),
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_191_ZULU"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.191"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_80 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_80"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.80 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_71 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_71"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.71 (Oracle)"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java 1.7.0_51 (Oracle)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsRuntimeSettings: &armappservice.WebAppRuntimeSettings{
		// 										AppInsightsSettings: &armappservice.AppInsightsWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										GitHubActionSettings: &armappservice.GitHubActionWebAppStackSettings{
		// 											IsSupported: to.Ptr(false),
		// 										},
		// 										IsDeprecated: to.Ptr(true),
		// 										RemoteDebuggingSupported: to.Ptr(false),
		// 										RuntimeVersion: to.Ptr("1.7.0_51"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.51 (Oracle)"),
		// 						}},
		// 						Value: to.Ptr("7"),
		// 				}},
		// 				PreferredOs: to.Ptr(armappservice.StackPreferredOsLinux),
		// 				Value: to.Ptr("java"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("javacontainers"),
		// 			Type: to.Ptr("Microsoft.Web/webAppStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Web/webAppStacks/javacontainers"),
		// 			Properties: &armappservice.WebAppStackProperties{
		// 				DisplayText: to.Ptr("Java Containers"),
		// 				MajorVersions: []*armappservice.WebAppMajorVersion{
		// 					{
		// 						DisplayText: to.Ptr("Java SE (Embedded Web Server)"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Java SE (Embedded Web Server)"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("JAVA|11-java11"),
		// 										Java8Runtime: to.Ptr("JAVA|8-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JAVA"),
		// 										JavaContainerVersion: to.Ptr("SE"),
		// 									},
		// 								},
		// 								Value: to.Ptr("SE"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.7"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.7"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.7"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 11.0.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("JAVA|11.0.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("11.0.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u252"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u252"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.252"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u242"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u242"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.242"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Java SE 8u232"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java8Runtime: to.Ptr("JAVA|8u232"),
		// 									},
		// 								},
		// 								Value: to.Ptr("1.8.232"),
		// 						}},
		// 						Value: to.Ptr("javase"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("JBoss EAP"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("JBoss EAP 7.2"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsPreview: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("JBOSSEAP|7.2-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.2"),
		// 						}},
		// 						Value: to.Ptr("jbosseap"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 9.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.37"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.37-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.37-java8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.37"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.37"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.33"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.33-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.33-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.33"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.31"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.31"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.31"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.27"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.27"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.27"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.21"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.21"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.21"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.20"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|9.0.20-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|9.0.20-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.20"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.14"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.12"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.12"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.12"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.8"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.8"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 9.0.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("9.0.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.0.0"),
		// 						}},
		// 						Value: to.Ptr("tomcat9.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 8.5"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5-jre8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.6"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.6"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.6"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.57"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.57-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.57-java8"),
		// 									},
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.57"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.57"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.53"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.53-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.53-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.53"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.51"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.51"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.51"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.47"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.47"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.47"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.42"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.42"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.42"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.41"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										Java11Runtime: to.Ptr("TOMCAT|8.5.41-java11"),
		// 										Java8Runtime: to.Ptr("TOMCAT|8.5.41-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.41"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.37"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.37"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.37"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.34"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.34"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.34"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.31"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.31"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.31"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.5.20"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.5.20"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.5.20"),
		// 						}},
		// 						Value: to.Ptr("tomcat8.5"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 8.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.53"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.53"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.53"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.46"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.46"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.46"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 8.0.23"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("8.0.23"),
		// 									},
		// 								},
		// 								Value: to.Ptr("8.0.23"),
		// 						}},
		// 						Value: to.Ptr("tomcat8.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Tomcat 7.0"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.94"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.94"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.94"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.81"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.81"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.81"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.62"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.62"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.62"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Tomcat 7.0.50"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										JavaContainer: to.Ptr("TOMCAT"),
		// 										JavaContainerVersion: to.Ptr("7.0.50"),
		// 									},
		// 								},
		// 								Value: to.Ptr("7.0.50"),
		// 						}},
		// 						Value: to.Ptr("tomcat7.0"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Jetty 9.3"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3.25"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3.25"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3.25"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.3.13"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.3.13"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.3.13"),
		// 						}},
		// 						Value: to.Ptr("jetty9.3"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("Jetty 9.1"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.1"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.1"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("Jetty 9.1.0"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									WindowsContainerSettings: &armappservice.WindowsJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										JavaContainer: to.Ptr("JETTY"),
		// 										JavaContainerVersion: to.Ptr("9.1.0"),
		// 									},
		// 								},
		// 								Value: to.Ptr("9.1.0"),
		// 						}},
		// 						Value: to.Ptr("jetty9.1"),
		// 					},
		// 					{
		// 						DisplayText: to.Ptr("WildFly 14"),
		// 						MinorVersions: []*armappservice.WebAppMinorVersion{
		// 							{
		// 								DisplayText: to.Ptr("WildFly 14"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsAutoUpdate: to.Ptr(true),
		// 										IsDeprecated: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("WILDFLY|14-jre8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14"),
		// 							},
		// 							{
		// 								DisplayText: to.Ptr("WildFly 14.0.1"),
		// 								StackSettings: &armappservice.WebAppRuntimes{
		// 									LinuxContainerSettings: &armappservice.LinuxJavaContainerSettings{
		// 										IsDeprecated: to.Ptr(true),
		// 										Java8Runtime: to.Ptr("WILDFLY|14.0.1-java8"),
		// 									},
		// 								},
		// 								Value: to.Ptr("14.0.1"),
		// 						}},
		// 						Value: to.Ptr("wildfly14"),
		// 				}},
		// 				Value: to.Ptr("javacontainers"),
		// 			},
		// 	}},
		// }
	}
}
