//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/healthcareapis/armhealthcareapis"
	"net/http"
	"net/url"
	"regexp"
)

// IotConnectorFhirDestinationServer is a fake server for instances of the armhealthcareapis.IotConnectorFhirDestinationClient type.
type IotConnectorFhirDestinationServer struct {
	// BeginCreateOrUpdate is the fake for method IotConnectorFhirDestinationClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string, fhirDestinationName string, iotFhirDestination armhealthcareapis.IotFhirDestination, options *armhealthcareapis.IotConnectorFhirDestinationClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method IotConnectorFhirDestinationClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string, fhirDestinationName string, options *armhealthcareapis.IotConnectorFhirDestinationClientBeginDeleteOptions) (resp azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IotConnectorFhirDestinationClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string, fhirDestinationName string, options *armhealthcareapis.IotConnectorFhirDestinationClientGetOptions) (resp azfake.Responder[armhealthcareapis.IotConnectorFhirDestinationClientGetResponse], errResp azfake.ErrorResponder)
}

// NewIotConnectorFhirDestinationServerTransport creates a new instance of IotConnectorFhirDestinationServerTransport with the provided implementation.
// The returned IotConnectorFhirDestinationServerTransport instance is connected to an instance of armhealthcareapis.IotConnectorFhirDestinationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIotConnectorFhirDestinationServerTransport(srv *IotConnectorFhirDestinationServer) *IotConnectorFhirDestinationServerTransport {
	return &IotConnectorFhirDestinationServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientDeleteResponse]](),
	}
}

// IotConnectorFhirDestinationServerTransport connects instances of armhealthcareapis.IotConnectorFhirDestinationClient to instances of IotConnectorFhirDestinationServer.
// Don't use this type directly, use NewIotConnectorFhirDestinationServerTransport instead.
type IotConnectorFhirDestinationServerTransport struct {
	srv                 *IotConnectorFhirDestinationServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armhealthcareapis.IotConnectorFhirDestinationClientDeleteResponse]]
}

// Do implements the policy.Transporter interface for IotConnectorFhirDestinationServerTransport.
func (i *IotConnectorFhirDestinationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IotConnectorFhirDestinationClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "IotConnectorFhirDestinationClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "IotConnectorFhirDestinationClient.Get":
		resp, err = i.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IotConnectorFhirDestinationServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HealthcareApis/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iotconnectors/(?P<iotConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fhirdestinations/(?P<fhirDestinationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhealthcareapis.IotFhirDestination](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		iotConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotConnectorName")])
		if err != nil {
			return nil, err
		}
		fhirDestinationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fhirDestinationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, iotConnectorNameParam, fhirDestinationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *IotConnectorFhirDestinationServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HealthcareApis/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iotconnectors/(?P<iotConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fhirdestinations/(?P<fhirDestinationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		iotConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotConnectorName")])
		if err != nil {
			return nil, err
		}
		fhirDestinationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fhirDestinationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, workspaceNameParam, iotConnectorNameParam, fhirDestinationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *IotConnectorFhirDestinationServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HealthcareApis/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iotconnectors/(?P<iotConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fhirdestinations/(?P<fhirDestinationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	iotConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotConnectorName")])
	if err != nil {
		return nil, err
	}
	fhirDestinationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fhirDestinationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, iotConnectorNameParam, fhirDestinationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IotFhirDestination, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
