![SPIKE](assets/spike-banner-lg.png)

## Welcome

Thank you for your interest in contributing to **SPIKE** 🤘.

We appreciate any help, be it in the form of code, documentation, design,
or even bug reports and feature requests.

When contributing to this repository, please first discuss the change you wish
to make via an issue, email, or any other method before making a change.
This way, we can avoid misunderstandings and wasted effort.

One great way to initiate such discussions is asking a question
[SPIFFE Slack Community][slack].

[slack]: https://slack.spiffe.io/ "Join SPIFFE on Slack"

Please note that [we have a code of conduct](CODE_OF_CONDUCT.md). We expect all
contributors to adhere to it in all interactions with the project.

Also, make sure you read, understand and accept
[The Developer Certificate of Origin Contribution Guide](CONTRIBUTING_DCO.md)
as it is a requirement to contribute to this project and contains more details
about the contribution process.

## How To Run Tests

Before merging your changes or creating a Pull Request, make sure all tests
pass and code quality checks are satisfied.

To test the SDK locally and run quality checks, use the following commands in
the project root:

```bash
# Run all tests
make test

# Run code quality and security audit
make audit
```
