/* Copyright (C) 2020-2022 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

#ifndef _GVMD_MANAGE_SQL_REPORT_FORMATS_H
#define _GVMD_MANAGE_SQL_REPORT_FORMATS_H

#include "manage_report_formats.h"

#include <glib.h>

gboolean
lookup_report_format (const char*, report_format_t*);

gboolean
find_report_format_no_acl (const char *, report_format_t *);

gboolean
find_trash_report_format_no_acl (const char *, report_format_t *);

int
create_report_format_no_acl (const char *, const char *, const char *,
                             const char *, const char *, const char *,
                             array_t *, array_t *, array_t *, const char *,
                             int, const char *, report_format_t *);

const char**
report_format_filter_columns ();

column_t*
report_format_select_columns ();

int
restore_report_format (const char *);

gchar *
apply_report_format (gchar *, report_config_t, gchar *, gchar *, gchar *,
                     GList **);

gboolean
delete_report_formats_user (user_t, iterator_t *);

void
delete_report_format_dirs_user (const gchar *, iterator_t *);

int
empty_trashcan_report_formats ();

gboolean
inherit_report_formats (user_t, user_t, iterator_t *);

void
inherit_report_format_dir (const gchar *, const gchar *, user_t);

void
update_report_format (report_format_t, const gchar *, const gchar *,
                      const gchar *, const gchar *, const gchar *,
                      const gchar *, const gchar *, array_t *, array_t *,
                      array_t *, const gchar *, const gchar *);

int
report_format_updated_in_feed (report_format_t, const gchar *);

int
deprecated_report_format_id_updated_in_feed (const char*, const gchar *);

int
migrate_predefined_report_formats ();

int
check_db_report_formats (int);

int
check_db_report_formats_trash ();

int
print_report_xml_end (gchar *, gchar *, report_format_t, report_config_t);

#endif /* not _GVMD_MANAGE_SQL_REPORT_FORMATS_H */
