/*
 *  $Id: layer-utils.c 27952 2025-05-09 16:41:38Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"

#include "libgwyddion/macros.h"
#include "libgwyddion/math.h"

#include "libgwyui/layer-utils.h"

/* FIXME GTK3 this is of course all wrong, but something like it will have to do for now. */
void
_gwy_transform_line_to_target(GwyDataView *view,
                              gdouble xfrom, gdouble yfrom,
                              gdouble xto, gdouble yto,
                              gdouble *xifrom, gdouble *yifrom,
                              gdouble *xito, gdouble *yito)
{
    gwy_data_view_coords_real_to_widget(view, xfrom, yfrom, xifrom, yifrom);
    gwy_data_view_coords_real_to_widget(view, xto, yto, xito, yito);
    gwy_data_view_coords_widget_cut_line(view, xifrom, yifrom, xito, yito);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
