/*-
 * SPDX-License-Identifier: BSD-2-Clause
 * 
 * Copyright (c) 2026 Maarten L. Hekkelman
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//[ serialisation
#include "zeem.hpp"

#include <cstdint>
#include <fstream>
#include <string>
#include <vector>

struct Person
{
    std::string firstname;
    std::string lastname;

    /* A struct we want to serialize needs a `serialize` method */
    template<class Archive>
    void serialize(Archive& ar, [[maybe_unused]] uint64_t version)
    {
        ar & zeem::make_element_nvp("firstname", firstname)
           & zeem::make_element_nvp("lastname", lastname);
    }
};

int main()
{
    /* Read in a text document containing XML and parse it into a document object */
    std::ifstream file("test.xml");
    zeem::document doc(file);
    
    std::vector<Person> persons;
    /* Deserialize all persons into an array */
    from_xml(doc, "persons", persons);

    doc.clear();

    /* Serialize all persons back into an XML document again */
    to_xml(doc, "persons", persons);

    return 0;
}
//]
