/*
* Copyright (c) 2018-2026 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

using Gtk;

public class UndoGroupAdd : UndoItem {

  private NodeGroup _group;

  //-------------------------------------------------------------
  // Constructor for adding a group.
  public UndoGroupAdd( NodeGroup group ) {
    base( _( "add group" ) );
    _group = group;
  }

  //-------------------------------------------------------------
  // Undoes a connection change.
  public override void undo( MindMap map ) {
    map.groups.remove_group( _group );
    map.queue_draw();
    map.auto_save();
  }

  //-------------------------------------------------------------
  // Redoes a connection change.
  public override void redo( MindMap map ) {
    map.groups.add_group( _group );
    map.queue_draw();
    map.auto_save();
  }

}
