/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"

/* -- Begin Profiling Symbol Block for routine MPI_Abi_get_version */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Abi_get_version = PMPI_Abi_get_version
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Abi_get_version  MPI_Abi_get_version
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Abi_get_version as PMPI_Abi_get_version
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Abi_get_version(int *abi_major, int *abi_minor)
     __attribute__ ((weak, alias("PMPI_Abi_get_version")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Abi_get_version
#define MPI_Abi_get_version PMPI_Abi_get_version
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Abi_get_version(int *abi_major, int *abi_minor)
{
    int mpi_errno = MPI_SUCCESS;
    MPIR_FUNC_TERSE_ENTER;

#ifdef HAVE_ERROR_CHECKING
    {
        MPID_BEGIN_ERROR_CHECKS;
        {
            MPIR_ERRTEST_ARGNULL(abi_major, "abi_major", mpi_errno);
            MPIR_ERRTEST_ARGNULL(abi_minor, "abi_minor", mpi_errno);
        }
        MPID_END_ERROR_CHECKS;
    }
#endif /* HAVE_ERROR_CHECKING */

    /* ... body of routine ... */
    *abi_major = -1;
    *abi_minor = -1;
    if (mpi_errno != MPI_SUCCESS)
        goto fn_fail;
    /* ... end of body of routine ... */

  fn_exit:
    MPIR_FUNC_TERSE_EXIT;
    return mpi_errno;

  fn_fail:
    /* --BEGIN ERROR HANDLINE-- */
#ifdef HAVE_ERROR_CHECKING
    mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_RECOVERABLE, __func__, __LINE__, MPI_ERR_OTHER,
                                     "**mpi_abi_get_version", "**mpi_abi_get_version %p %p", abi_major,
                                     abi_minor);
#endif
    mpi_errno = MPIR_Err_return_comm(0, __func__, mpi_errno);
    /* --END ERROR HANDLING-- */
    goto fn_exit;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Abi_get_version(QMPI_Context context, int tool_id, int *abi_major, int *abi_minor)
{
    return internal_Abi_get_version(abi_major, abi_minor);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Abi_get_version(int *abi_major, int *abi_minor)
{
    QMPI_Context context;
    QMPI_Abi_get_version_t *fn_ptr;

    context.storage_stack = NULL;

    int mpi_errno = MPI_SUCCESS;
    mpi_errno = MPII_qmpi_init();
    if (mpi_errno != MPI_SUCCESS) {
        return mpi_errno;
    }

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Abi_get_version(context, 0, abi_major, abi_minor);

    fn_ptr = (QMPI_Abi_get_version_t *) MPIR_QMPI_first_fn_ptrs[MPI_ABI_GET_VERSION_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_ABI_GET_VERSION_T], abi_major,
            abi_minor);
}
#else /* ENABLE_QMPI */
int MPI_Abi_get_version(int *abi_major, int *abi_minor)
{
    return internal_Abi_get_version(abi_major, abi_minor);
}

#endif /* ENABLE_QMPI */
