(* TEST
 modules = "test6_.c";
*)

(* Tests nested calls from C (main C) to OCaml (main OCaml) to C (caml_to_c) to
 * OCaml (c_to_caml) to C (printf functions). Exception is raised in a
 * Callback, which unwinds the C stack and gets caught in OCaml. *)

exception E

let printf = Printf.printf

let c_to_caml () =
  printf "[Caml] Enter c_to_caml\n%!";
  printf "[Caml] c_to_caml: raise exception\n%!";
  raise E

let _ = Callback.register "c_to_caml" c_to_caml

external caml_to_c : unit -> unit = "caml_to_c"

let _ =
  try
    printf "[Caml] Call caml_to_c\n%!";
    caml_to_c ();
    printf "[Caml] Return from caml_to_c\n%!"
  with E ->
    (printf "[Caml] Caught exception\n%!";
     try caml_to_c() with E -> printf "[Caml] Caught exceception again\n%!";
     printf "[Caml] Done\n%!")
