% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable-package.R
\docType{package}
\name{flextable-package}
\alias{flextable-package}
\title{flextable: Functions for Tabular Reporting}
\description{
The flextable package facilitates access to and manipulation of
tabular reporting elements from R.

The documentation of functions can be opened with command \code{help(package = "flextable")}.

\code{flextable()} function is producing flexible tables where each cell
can contain several chunks of text with their own set of formatting
properties (bold, font color, etc.). Function \code{\link[=mk_par]{mk_par()}} lets customise
text of cells.

Each cell holds a single paragraph composed of inline chunks
(see \code{\link[=as_paragraph]{as_paragraph()}}). This means cell content is strictly
inline: bold, italic, links, images, equations, inline code, etc.
Block-level structures (multiple paragraphs, bullet lists,
headings or fenced code blocks) cannot be placed inside a cell.
Soft line breaks (\verb{\\n}) are however supported.

The \code{\link[=as_flextable]{as_flextable()}} function is used to transform specific objects into
flextable objects. For example, you can transform a crosstab produced with
the 'tables' package into a flextable which can then be formatted,
annotated or augmented with footnotes.

In order to reduce the homogenization efforts and the number of functions
to be called, it is recommended to define formatting properties such as
font, border color, number of decimals displayed which will then be applied
by default. See \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} for more details.
}
\section{Table Structure}{


A flextable is composed of three distinct parts:
\itemize{
\item \code{header}: By default, contains one row with the column names from the data.frame
\item \code{body}: Contains the actual data from the data.frame
\item \code{footer}: Empty by default, but can contain content (commonly used for footnotes or #' summary rows)
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{       HEADER         <- Column names, labels, spanning headers
--------------------
        BODY          <- Data rows
--------------------
       FOOTER         <- Summary rows, notes, footnotes (optional)
}\if{html}{\out{</div>}}

A basic flextable has:
\itemize{
\item in the part 'header': 1 row with column names
\item in the part 'body': as many rows as there are in the input data.frame
\item no footer
}

Rows and columns can be added or removed to the basic flextable:
\itemize{
\item Add new rows in header with \code{\link[=add_header]{add_header()}}, \code{\link[=add_header_row]{add_header_row()}},
\code{\link[=add_header_lines]{add_header_lines()}} and \code{\link[=set_header_labels]{set_header_labels()}}.
\item Add new rows in footer with \code{\link[=add_footer]{add_footer()}}, \code{\link[=add_footer_lines]{add_footer_lines()}},
\code{\link[=set_header_footer_df]{set_header_footer_df()}} and \code{\link[=add_footer_row]{add_footer_row()}}.
\item Add new rows in body with \code{\link[=add_body]{add_body()}} and \code{\link[=add_body_row]{add_body_row()}}.
\item Delete columns with \code{\link[=delete_columns]{delete_columns()}}.
\item Delete a part with \code{\link[=delete_part]{delete_part()}}.
\item Use column names to separate a simple header row into multiple nested
rows with \code{\link[=separate_header]{separate_header()}}.
}
}

\section{Selectors in flextable}{

Selectors are a core feature of flextable that allow you to specify which
parts (\code{part}), rows (\code{i}) and columns (\code{j}) should be affected by formatting,
styling, or content operations. See the corresponding manual:
<\code{\link[=flextable_selectors]{Selectors in flextable}}>.
}

\seealso{
\url{https://davidgohel.github.io/flextable/},
\url{https://ardata-fr.github.io/flextable-book/}, \code{\link[=flextable]{flextable()}}
}
\author{
\strong{Maintainer}: David Gohel \email{david.gohel@ardata.fr}

Authors:
\itemize{
  \item Panagiotis Skintzos \email{panagiotis.skintzos@ardata.fr}
}

Other contributors:
\itemize{
  \item ArData [copyright holder]
  \item Clementine Jager [contributor]
  \item Eli Daniels [contributor]
  \item Quentin Fazilleau [contributor]
  \item Maxim Nazarov [contributor]
  \item Titouan Robert [contributor]
  \item Michael Barrowman [contributor]
  \item Atsushi Yasumoto [contributor]
  \item Paul Julian [contributor]
  \item Sean Browning [contributor]
  \item Rémi Thériault (\href{https://orcid.org/0000-0003-4315-6788}{ORCID}) [contributor]
  \item Samuel Jobert [contributor]
  \item Keith Newman [contributor]
}

}
