% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{tabset}
\alias{tabset}
\title{Represent a (recursive) list with (nested) tabsets}
\usage{
tabset(x, value = str)
}
\arguments{
\item{x}{A list.}

\item{value}{A function to print the value of a list member. By default,
\code{\link[=str]{str()}} is used to print the structure of the value. You may also use
\code{\link[=dput]{dput()}} to output the full value, but it may be slow when the size of the
value is too big.}
}
\value{
A character vector of Markdown that can be rendered to HTML with
\code{\link[litedown:mark]{litedown::mark()}}.
}
\description{
The tab titles are names of list members, and the tab content contains the
values of list members. If a list member is also a list, it will be
represented recursively with a child tabset.
}
\examples{
xfun::tabset(iris)
xfun::tabset(iris, dput)
xfun::tabset(iris, print)

# a deeply nested list
plot(1:10)
p = recordPlot()
xfun::tabset(p)
}
