// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tlog

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewGetLogProofParams creates a new GetLogProofParams object
// with the default values initialized.
func NewGetLogProofParams() GetLogProofParams {

	var (
		// initialize parameters with default values

		firstSizeDefault = int64(1)
	)

	return GetLogProofParams{
		FirstSize: &firstSizeDefault,
	}
}

// GetLogProofParams contains all the bound params for the get log proof operation
// typically these are obtained from a http.Request
//
// swagger:parameters getLogProof
type GetLogProofParams struct {
	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The size of the tree that you wish to prove consistency from (1 means the beginning of the log) Defaults to 1 if not specified

	  Minimum: 1
	  In: query
	  Default: 1
	*/
	FirstSize *int64

	/*The size of the tree that you wish to prove consistency to
	  Required: true
	  Minimum: 1
	  In: query
	*/
	LastSize int64

	/*The tree ID of the tree that you wish to prove consistency for
	  Pattern: ^[0-9]+$
	  In: query
	*/
	TreeID *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetLogProofParams() beforehand.
func (o *GetLogProofParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r
	qs := runtime.Values(r.URL.Query())

	qFirstSize, qhkFirstSize, _ := qs.GetOK("firstSize")
	if err := o.bindFirstSize(qFirstSize, qhkFirstSize, route.Formats); err != nil {
		res = append(res, err)
	}

	qLastSize, qhkLastSize, _ := qs.GetOK("lastSize")
	if err := o.bindLastSize(qLastSize, qhkLastSize, route.Formats); err != nil {
		res = append(res, err)
	}

	qTreeID, qhkTreeID, _ := qs.GetOK("treeID")
	if err := o.bindTreeID(qTreeID, qhkTreeID, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindFirstSize binds and validates parameter FirstSize from query.
func (o *GetLogProofParams) bindFirstSize(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewGetLogProofParams()
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("firstSize", "query", "int64", raw)
	}
	o.FirstSize = &value

	if err := o.validateFirstSize(formats); err != nil {
		return err
	}

	return nil
}

// validateFirstSize carries out validations for parameter FirstSize
func (o *GetLogProofParams) validateFirstSize(formats strfmt.Registry) error {

	if err := validate.MinimumInt("firstSize", "query", *o.FirstSize, 1, false); err != nil {
		return err
	}

	return nil
}

// bindLastSize binds and validates parameter LastSize from query.
func (o *GetLogProofParams) bindLastSize(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("lastSize", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("lastSize", "query", raw); err != nil {
		return err
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("lastSize", "query", "int64", raw)
	}
	o.LastSize = value

	if err := o.validateLastSize(formats); err != nil {
		return err
	}

	return nil
}

// validateLastSize carries out validations for parameter LastSize
func (o *GetLogProofParams) validateLastSize(formats strfmt.Registry) error {

	if err := validate.MinimumInt("lastSize", "query", o.LastSize, 1, false); err != nil {
		return err
	}

	return nil
}

// bindTreeID binds and validates parameter TreeID from query.
func (o *GetLogProofParams) bindTreeID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.TreeID = &raw

	if err := o.validateTreeID(formats); err != nil {
		return err
	}

	return nil
}

// validateTreeID carries out validations for parameter TreeID
func (o *GetLogProofParams) validateTreeID(formats strfmt.Registry) error {

	if err := validate.Pattern("treeID", "query", *o.TreeID, `^[0-9]+$`); err != nil {
		return err
	}

	return nil
}
