#include "stdafx.h"
#include "TObject.h"

namespace storm {

	TObject::TObject(Thread *t) : thread(t) {}

	Str *TObject::toS() const {
		return RootObject::toS();
	}

	void TObject::toS(StrBuf *buf) const {
		RootObject::toS(buf);
	}

	Str *threadSafeToS(RootObject *obj) {
		if (TObject *tObj = as<TObject>(obj)) {
			Thread *thread = tObj->associatedThread();
			const os::Thread &osThread = thread->thread();
			if (osThread != os::Thread::current()) {
				os::Future<Str *> result;
				os::FnCall<Str *, 1> call = os::fnCall().add(tObj);
				Str *(CODECALL TObject::*ptr)() const = &TObject::toS;
				os::UThread::spawn(address(ptr), true, call, result, &osThread);
				return result.result();
			} else {
				return obj->toS();
			}
		} else {
			return obj->toS();
		}
	}

}
