#!/usr/bin/python

import sys;
from structs import structs, compat_arches;

# command line arguments
outfile = sys.argv[1];
archs   = sys.argv[2:];

f = open(outfile, "w");
f.write('''
/*
 * sanity checks for generated foreign headers:
 *  - verify struct sizes
 *
 * generated by %s -- DO NOT EDIT
 */
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <inttypes.h>
''');

for a in archs:
    f.write('#include "%s.h"\n' % a);

f.write('int main(int argc, char *argv[])\n{\n');

f.write('\tprintf("\\n");');
f.write('printf("%-25s |", "structs");\n');
for a in archs:
    f.write('\tprintf("%%8s", "%s");\n' % a);
f.write('\tprintf("\\n");');

f.write('\tprintf("\\n");');
for struct in structs:
    f.write('\tprintf("%%-25s |", "%s");\n' % struct);
    for a in archs:
        s = struct + "_" + a;
        if a in compat_arches:
            compat = compat_arches[a]
            c = struct + "_" + compat;
        else:
            compat = None
        f.write('#ifdef %s_has_no_%s\n' % (a, struct));
        f.write('\tprintf("%8s",\n');
        if compat:
            f.write('# ifndef %s_has_no_%s\n' % (compat, struct));
            f.write('\t\t"!"\n');
            f.write('# else\n')
            f.write('\t\t"-"\n');
            f.write('# endif\n')
        else:
            f.write('\t\t"-"\n');
        f.write('\t);\n')
        f.write("#else\n");
        f.write('\tprintf("%%8zd", sizeof(struct %s));\n' % s);
        if compat:
            f.write('\tif (sizeof(struct %s) != sizeof(struct %s))\n' % (s, c))
            f.write('\t\tprintf("!");\n')
        f.write("#endif\n");

    f.write('\tprintf("\\n");\n\n');

f.write('\tprintf("\\n");\n');
f.write('\texit(0);\n');
f.write('}\n');

f.close();

