/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "host/commands/cvd/cli/parser/cf_configs_instances.h"

#include <string>
#include <vector>

#include <android-base/logging.h>

#include "common/libs/utils/result.h"
#include "cuttlefish/host/commands/cvd/cli/parser/load_config.pb.h"
#include "host/commands/cvd/cli/parser/cf_configs_common.h"
#include "host/commands/cvd/cli/parser/instance/cf_boot_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_connectivity_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_disk_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_graphics_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_security_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_streaming_configs.h"
#include "host/commands/cvd/cli/parser/instance/cf_vm_configs.h"

namespace cuttlefish {

using cvd::config::EnvironmentSpecification;

Result<std::vector<std::string>> GenerateInstancesFlags(
    const EnvironmentSpecification& cfg) {
  std::vector<std::string> res = CF_EXPECT(GenerateBootFlags(cfg));
  res = MergeResults(std::move(res), GenerateDiskFlags(cfg));
  res = MergeResults(std::move(res), CF_EXPECT(GenerateGraphicsFlags(cfg)));
  res = MergeResults(std::move(res), GenerateSecurityFlags(cfg));
  res = MergeResults(std::move(res), GenerateStreamingFlags(cfg));
  res = MergeResults(std::move(res), CF_EXPECT(GenerateVmFlags(cfg)));
  res = MergeResults(std::move(res), GenerateConnectivityFlags(cfg));
  return res;
}

}  // namespace cuttlefish
