"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaxpIo = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
exports.MaxpIo = {
    ...(0, bin_util_1.Read)(vw => {
        const version = vw.uint32();
        const maxp = ot_metadata_1.Maxp.Table.FromVersion(version);
        maxp.numGlyphs = vw.uint16();
        if (maxp.version >= 0x10000) {
            maxp.maxPoints = vw.uint16();
            maxp.maxContours = vw.uint16();
            maxp.maxCompositePoints = vw.uint16();
            maxp.maxCompositeContours = vw.uint16();
            maxp.maxZones = vw.uint16();
            maxp.maxTwilightPoints = vw.uint16();
            maxp.maxStorage = vw.uint16();
            maxp.maxFunctionDefs = vw.uint16();
            maxp.maxInstructionDefs = vw.uint16();
            maxp.maxStackElements = vw.uint16();
            maxp.maxSizeOfInstructions = vw.uint16();
            maxp.maxComponentElements = vw.uint16();
            maxp.maxComponentDepth = vw.uint16();
        }
        return maxp;
    }),
    ...(0, bin_util_1.Write)((fr, maxp) => {
        fr.uint32(maxp.version);
        fr.uint16(maxp.numGlyphs);
        if (maxp.version >= 0x10000) {
            fr.uint16(maxp.maxPoints);
            fr.uint16(maxp.maxContours);
            fr.uint16(maxp.maxCompositePoints);
            fr.uint16(maxp.maxCompositeContours);
            fr.uint16(maxp.maxZones);
            fr.uint16(maxp.maxTwilightPoints);
            fr.uint16(maxp.maxStorage);
            fr.uint16(maxp.maxFunctionDefs);
            fr.uint16(maxp.maxInstructionDefs);
            fr.uint16(maxp.maxStackElements);
            fr.uint16(maxp.maxSizeOfInstructions);
            fr.uint16(maxp.maxComponentElements);
            fr.uint16(maxp.maxComponentDepth);
        }
    })
};
//# sourceMappingURL=index.js.map