"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpT = void 0;
class OpT {
    constructor(vsX, factory) {
        this.vsX = vsX;
        this.factory = factory;
        this.neutral = factory.create(vsX.neutral, vsX.neutral, 0);
    }
    add(a, b) {
        return this.factory.create(this.vsX.add(a.x, b.x), this.vsX.add(a.y, b.y), a.kind);
    }
    negate(a) {
        return this.factory.create(this.vsX.negate(a.x), this.vsX.negate(a.y), a.kind);
    }
    minus(a, b) {
        return this.factory.create(this.vsX.minus(a.x, b.x), this.vsX.minus(a.y, b.y), a.kind);
    }
    scale(s, a) {
        return this.factory.create(this.vsX.scale(s, a.x), this.vsX.scale(s, a.y), a.kind);
    }
    addScale(a, s, b) {
        return this.factory.create(this.vsX.add(a.x, this.vsX.scale(s, b.x)), this.vsX.add(a.y, this.vsX.scale(s, b.y)), a.kind);
    }
    applyTransform(a, t) {
        if (t.scaledOffset) {
            const x0 = this.vsX.add(a.x, t.dx);
            const y0 = this.vsX.add(a.y, t.dy);
            return this.factory.create(this.vsX.addScale(this.vsX.scale(t.xx, x0), t.yx, y0), this.vsX.addScale(this.vsX.scale(t.xy, x0), t.yy, y0), a.kind);
        }
        else {
            // ⎛ xx yx ⎞ ⎛ x ⎞ + ⎛ dx ⎞ == ⎛ dx + xx * x + yx * y ⎞
            // ⎝ xy yy ⎠ ⎝ y ⎠ + ⎝ dy ⎠ == ⎝ dy + xy * x + yy * y ⎠
            return this.factory.create(this.vsX.addScale(this.vsX.addScale(t.dx, t.xx, a.x), t.yx, a.y), this.vsX.addScale(this.vsX.addScale(t.dy, t.xy, a.x), t.yy, a.y), a.kind);
        }
    }
    removeScaledOffset(t) {
        // ⎛ xx yx ⎞ ⎛ x + dx ⎞ = ⎛ xx yx ⎞ ⎛ x ⎞ + ⎛ xx yx ⎞ ⎛ x ⎞
        // ⎝ xy yy ⎠ ⎝ y + dy ⎠ = ⎝ xy yy ⎠ ⎝ y ⎠ + ⎝ xy yy ⎠ ⎝ y ⎠
        if (!t.scaledOffset)
            return t;
        return {
            xx: t.xx,
            yx: t.yx,
            xy: t.xy,
            yy: t.yy,
            dx: this.vsX.addScale(this.vsX.scale(t.xx, t.dx), t.yx, t.dy),
            dy: this.vsX.addScale(this.vsX.scale(t.xy, t.dx), t.yy, t.dy)
        };
    }
    combineTransform(_a, _b) {
        // ⎛ a.xx a.yx ⎞ ⎡⎛ b.xx b.yx ⎞ ⎛ x ⎞ + ⎛ b.dx ⎞⎤ + ⎛ a.dx ⎞
        // ⎝ a.xy a.yy ⎠ ⎣⎝ b.xy b.yy ⎠ ⎝ y ⎠ + ⎝ b.dy ⎠⎦ + ⎝ a.dy ⎠
        // == ⎛ a.xx a.yx ⎞ ⎛ b.xx b.yx ⎞ ⎛ x ⎞ + ⎡⎛ a.xx a.yx ⎞ ⎛ b.dx ⎞ + ⎛ a.dx ⎞⎤
        // == ⎝ a.xy a.yy ⎠ ⎝ b.xy b.yy ⎠ ⎝ y ⎠ + ⎣⎝ a.xy a.yy ⎠ ⎝ b.dy ⎠ + ⎝ a.dy ⎠⎦
        const a = this.removeScaledOffset(_a), b = this.removeScaledOffset(_b);
        return {
            xx: a.xx * b.xx + a.yx * b.xy,
            yx: a.xx * b.yx + a.yx * b.yy,
            xy: a.xy * b.xx + a.yy * b.xy,
            yy: a.xy * b.yx + a.yy * b.yy,
            dx: this.vsX.addScale(this.vsX.addScale(a.dx, a.xx, b.dx), a.yx, b.dy),
            dy: this.vsX.addScale(this.vsX.addScale(a.dy, a.xy, b.dx), a.yy, b.dy)
        };
    }
}
exports.OpT = OpT;
//# sourceMappingURL=point.js.map