"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const crypto = tslib_1.__importStar(require("crypto"));
const fs = tslib_1.__importStar(require("fs-extra"));
module.exports = function hashFile(path) {
    return new Promise((resolve, reject) => {
        let sum = crypto.createHash("sha1");
        let fileStream = fs.createReadStream(path);
        fileStream.on("error", (err) => {
            return reject(err);
        });
        fileStream.on("data", (chunk) => {
            try {
                sum.update(chunk);
            }
            catch (ex) {
                return reject(ex);
            }
        });
        fileStream.on("end", () => {
            return resolve(sum.digest("hex"));
        });
    });
};
