#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, see <https://www.gnu.org/licenses/>.
#

# -------------------------------------------------------------------------
#
# Standard Python modules
#
# -------------------------------------------------------------------------
from ....const import GRAMPS_LOCALE as glocale

_ = glocale.translation.gettext

# -------------------------------------------------------------------------
#
# Gramps modules
#
# -------------------------------------------------------------------------
from .. import Rule


# -------------------------------------------------------------------------
#
# Typing modules
#
# -------------------------------------------------------------------------
from ....lib import Person
from ....db import Database


# -------------------------------------------------------------------------
#
# IncompleteNames
#
# -------------------------------------------------------------------------
class IncompleteNames(Rule):
    """People with incomplete names"""

    name = _("People with incomplete names")
    description = _("Matches people with firstname or lastname missing")
    category = _("General filters")

    def apply_to_one(self, db: Database, person: Person) -> bool:
        for name in [person.primary_name] + person.alternate_names:
            if name.first_name.strip() == "":
                return True
            if name.surname_list:
                for surn in name.surname_list:
                    if surn.surname.strip() == "":
                        return True
            else:
                return True
        return False
