---
layout: page
title: Resources
permalink: /resources/
redirect_from:
 - /docs/resources/
---
Jekyll's growing community produces wide variety of themes, plugins, tutorials
and other resources that can be helpful. Below is a collection of links to
some of the most popular Jekyll resources.

## Themes
- [GitHub.com #jekyll-theme repos](https://github.com/topics/jekyll-theme)
- [jamstackthemes.dev](https://jamstackthemes.dev/ssg/jekyll/)
- [jekyllthemes.org](http://jekyllthemes.org/)
- [jekyllthemes.io](https://jekyllthemes.io/)

See also: [docs/themes](/docs/themes/).

## Plugins
- [jekyll-plugin topic on GitHub](https://github.com/topics/jekyll-plugin)
- [Planet Jekyll](https://github.com/planetjekyll/awesome-jekyll-plugins)

## Guides

- [Community tutorials]({{ '/tutorials/home/' | relative_url }})
- [Deploy Jekyll 4 on GitHub Pages]({{ '/docs/continuous-integration/github-actions/' | relative_url }})
- [Deploy Jekyll on Vercel](https://github.com/vercel/vercel/tree/master/examples/jekyll)
- [Deploy Jekyll 4 on Netlify](https://www.netlify.com/blog/2020/04/02/a-step-by-step-guide-jekyll-4.0-on-netlify/)
- [CloudCannon Academy](https://learn.cloudcannon.com/) is a set of resources created by [CloudCannon](https://cloudcannon.com/) to help folks get up and running with Jekyll. They cover all skill levels, and even include some great video tutorials.
- [Jekyll Cheatsheet](https://learn.cloudcannon.com/jekyll-cheat-sheet/) is a single-page resource for Jekyll filters, variables, and the like.

## Integrations

Use a SaaS service as a backend for functionality on your Jekyll site

### Comments
  - [Staticman](https://staticman.net): Add user-generated content to a Jekyll site (free and open source)
  - [Talkyard](https://www.talkyard.io/blog-comments): Embedded comments for Jekyll and others (free and open source, or hosted serverless)

### Content Management
  - [CloudCannon](https://cloudcannon.com/): The Cloud CMS for Jekyll
  - [Contentful](https://github.com/contentful/jekyll-contentful-data-import): Content infrastructure for digital teams
  - [Forestry.io](https://forestry.io/): A free Git-based responsive CMS, with content modeling and instant previews.
  - [Netlify CMS](https://www.netlifycms.org/): Open source content management for your Git workflow
  - [Siteleaf](https://www.siteleaf.com/): Built for developers, Loved by everyone
  - [Kentico Kontent](https://github.com/Kentico/kontent-jekyll): A headless CMS with full control over content presentation

### E-commerce
  - [MemberSpace](https://www.memberspace.com/integrations/jekyll-membership/): Add memberships and paywall functionality to a Jekyll site
  - [Snipcart](https://snipcart.com/blog/static-site-e-commerce-part-2-integrating-snipcart-with-jekyll): Add a shopping cart to a Jekyll site

### Forms
  - [Arengu](https://www.arengu.com)
  - [Getform](https://getform.io)
  - [99Inbound](https://www.99inbound.com)
  - [Formcake](https://formcake.com)
  - [Formcarry](https://formcarry.com)
  - [Formingo](https://www.formingo.co/guides/jekyll?utm_source=github&utm_medium=jekyll-docs&utm_campaign=Jekyll%20Documentation)
  - [FormKeep](https://formkeep.com/guides/contact-form-jekyll?utm_source=github&utm_medium=jekyll-docs&utm_campaign=contact-form-jekyll)
  - [Formspark](https://formspark.io/)
  - [Formspree (open source)](https://formspree.io/)
  - [formX](https://formx.stream)
  - [Simple Form](https://getsimpleform.com/)
  - [SmartForms](https://smartforms.dev/)
  - [Typeform](https://www.typeform.com/templates/c/forms/)

### Search
  - [Algolia](https://blog.algolia.com/instant-search-blog-documentation-jekyll-plugin/): Add a powerful instant search to your Jekyll site
  - [Elastic Site Search](http://elastic.co/products/site-search/service?ultron=resources&blade=jekyll&hulk=referral): Another option for adding search to your Jekyll site, built on Elasticsearch
  - [Bonsai Search](https://docs.bonsai.io/article/217-jekyll): The easiest way to use Elasticsearch for your Jekyll site
  - [CloudSh](https://cloudsh.com/generators/how-to-setup-search-on-jekyll/): Website search with a few lines of JavaScript

## Editors plugins

- Visual Studio Code has [various jekyll related plugins](https://marketplace.visualstudio.com/search?term=tag%3Ajekyll&target=VSCode&category=All%20categories&sortBy=Installs) and supports [autocompletion for configuration file](http://json.schemastore.org/jekyll).
- [jekyll-atom](https://atom.io/packages/jekyll): A collection of snippets and tools for Jekyll in Atom
- [markdown-writer](https://atom.io/packages/markdown-writer): An Atom package for Jekyll. It can create new posts/drafts, manage tags/categories, insert link/images and add many useful key mappings.
- [sublime-jekyll](https://github.com/23maverick23/sublime-jekyll): A Sublime Text package for Jekyll static sites. This package should help creating Jekyll sites and posts easier by providing access to key template tags and filters, as well as common completions and a current date/datetime command (for dating posts). You can install this package manually via GitHub, or via [Package Control](https://packagecontrol.io/packages/Jekyll).
- [vim-jekyll](https://github.com/parkr/vim-jekyll): A vim plugin to generate new posts and run `jekyll build` all without leaving vim.
- [WordPress2Jekyll](https://wordpress.org/plugins/wp2jekyll/): A WordPress plugin that allows you to use WordPress as your editor and (automatically) export content in to Jekyll. WordPress2Jekyll attempts to marry these two systems together in order to make a site that can be easily managed from all devices.

## Posts

- [How I'm using Jekyll in 2016](https://mademistakes.com/articles/using-jekyll-2016/)
- [Talkyard comments instructions for Jekyll](https://jekyll-demo.talkyard.io/2018/01/09/installation-instructions.html)
- [Static Comments with Jekyll & Staticman](https://mademistakes.com/articles/improving-jekyll-static-comments/)
- [Adding Ajax pagination to Jekyll](https://eduardoboucas.com/blog/2014/11/05/adding-ajax-pagination-to-jekyll.html)
- ['About this Website', by Carter Allen](http://cartera.me/2010/08/12/about-this-website/)

  > "Jekyll is everything that I ever wanted in a blogging engine. Really. It isn't perfect, but what's excellent about it is that if there's something wrong, I know exactly how it works and how to fix it. It runs on the your machine only, and is essentially an added"build" step between you and the browser. I coded this entire site in TextMate using standard HTML5 and CSS3, and then at the end I added just a few little variables to the markup. Presto-chango, my site is built and I am at peace with the world."

- A way to [extend Jekyll](https://github.com/rfelix/jekyll_ext) without forking and modifying the Jekyll gem codebase and some [portable Jekyll extensions](https://github.com/rfelix/jekyll_ext/wiki/Extensions) that can be reused and shared.
- [Using your Rails layouts in Jekyll](https://numbers.brighterplanet.com/2010/08/09/sharing-rails-views-with-jekyll)

## Forks

- [Time to Visit Bridgetown](https://www.bridgetownrb.com/news/time-to-visit-bridgetown/)
- [Creating a Faster Jekyll](https://sigpipe.macromates.com/2018/creating-a-faster-jekyll/)
