
/*
 * machinarium.
 *
 * cooperative multitasking engine.
 */

#include <errno.h>

#include <machinarium/machinarium.h>
#include <machinarium/iov.h>
#include <machinarium/machine.h>

MACHINE_API machine_iov_t *machine_iov_create(void)
{
	mm_iov_t *iov = mm_malloc(sizeof(mm_iov_t));
	if (iov == NULL) {
		mm_errno_set(ENOMEM);
		return NULL;
	}
	mm_iov_init(iov);
	return (machine_iov_t *)iov;
}

MACHINE_API void machine_iov_free(machine_iov_t *obj)
{
	mm_iov_t *iov = mm_cast(mm_iov_t *, obj);
	mm_iov_free(iov);
	mm_free(obj);
}

MACHINE_API int machine_iov_add_pointer(machine_iov_t *obj, void *pointer,
					int size)
{
	(void)obj;
	(void)pointer;
	(void)size;

	/* make sure function is unused now */
	abort();

	return -1;
}

MACHINE_API int machine_iov_add(machine_iov_t *obj, machine_msg_t *msg)
{
	mm_iov_t *iov = mm_cast(mm_iov_t *, obj);
	int rc;
	rc = mm_iov_add(iov, (mm_msg_t *)msg);
	if (rc == -1) {
		mm_errno_set(ENOMEM);
	}
	return rc;
}

MACHINE_API int machine_iov_pending(machine_iov_t *obj)
{
	mm_iov_t *iov = mm_cast(mm_iov_t *, obj);
	return mm_iov_pending(iov);
}

MACHINE_API size_t machine_iov_inflight_size(machine_iov_t *obj)
{
	mm_iov_t *iov = mm_cast(mm_iov_t *, obj);
	size_t total = 0;
	mm_list_t *i;
	mm_list_foreach (&iov->msg_list, i) {
		mm_msg_t *msg;
		msg = mm_container_of(i, mm_msg_t, link);
		total += mm_buf_size(&msg->data);
	}

	return total;
}
