[![CI](https://github.com/jkroepke/openvpn-auth-oauth2/actions/workflows/ci.yaml/badge.svg?branch=main)](https://github.com/jkroepke/openvpn-auth-oauth2/actions/workflows/ci.yaml)
[![GitHub license](https://img.shields.io/github/license/jkroepke/openvpn-auth-oauth2)](https://github.com/jkroepke/openvpn-auth-oauth2/blob/master/LICENSE.txt)
[![Current Release](https://img.shields.io/github/release/jkroepke/openvpn-auth-oauth2.svg?logo=github)](https://github.com/jkroepke/openvpn-auth-oauth2/releases/latest)
[![GitHub Repo stars](https://img.shields.io/github/stars/jkroepke/openvpn-auth-oauth2?style=flat&logo=github)](https://github.com/jkroepke/openvpn-auth-oauth2/stargazers)
[![GitHub all releases](https://img.shields.io/github/downloads/jkroepke/openvpn-auth-oauth2/total?logo=github)](https://github.com/jkroepke/openvpn-auth-oauth2/releases/latest)
[![Go Report Card](https://goreportcard.com/badge/github.com/jkroepke/openvpn-auth-oauth2)](https://goreportcard.com/report/github.com/jkroepke/openvpn-auth-oauth2)
[![codecov](https://codecov.io/gh/jkroepke/openvpn-auth-oauth2/graph/badge.svg?token=66VT000UYO)](https://codecov.io/gh/jkroepke/openvpn-auth-oauth2)

<p align="center">
<img aligin="center" src="https://github.com/jkroepke/openvpn-auth-oauth2/blob/main/docs/img/logo.svg?raw=true" alt="openvpn-auth-oauth2 logo"  style="height: 100px" />
</<p>

# openvpn-auth-oauth2

⭐ Don't forget to star this repository! ⭐

## About

[`openvpn-auth-oauth2`](https://github.com/jkroepke/openvpn-auth-oauth2) is a management client for OpenVPN that handles
the single sign-on (SSO) authentication against various OIDC providers. This project aims to simplify the process of
integrating OpenVPN with OIDC providers such as

* Microsoft Entra ID (Azure AD)
* GitHub
* Okta
* Google Workspace
* Authentik
* Zitadel
* DigitalOcean
* Keycloak
* [... any other OIDC compatible auth server](https://github.com/jkroepke/openvpn-auth-oauth2/wiki/Providers)

## Installation

For detailed installation instructions, please refer to the [Installation Guide](https://github.com/jkroepke/openvpn-auth-oauth2/wiki/Installation).

### Downstream Packages

[![Packaging status](https://repology.org/badge/vertical-allrepos/openvpn-auth-oauth2.svg)](https://repology.org/project/openvpn-auth-oauth2/versions)

## Configuration

For information on how to configure `openvpn-auth-oauth2`, please refer to the [Configuration Guide](https://github.com/jkroepke/openvpn-auth-oauth2/wiki/Configuration).

## OpenVPN Version Requirements

For information on the OpenVPN version requirements, please refer to the [OpenVPN Guide](https://github.com/jkroepke/openvpn-auth-oauth2/wiki/OpenVPN).

## Related Projects

- [openvpn-auth-aad](https://github.com/CyberNinjas/openvpn-auth-aad)
- [openvpn-oidc](https://github.com/vitaliy-sn/openvpn-oidc)
- [openvpn-auth-azure-ad](https://github.com/jkroepke/openvpn-auth-azure-ad)

## License

This project is licensed under the [MIT License](LICENSE.txt).

## Open Source Sponsors

Thanks to all sponsors!

* [@hegawa](https://github.com/hegawa) (25$) onetime
* [@Zero-Down-Time](https://github.com/Zero-Down-Time) (25$) onetime
* [@k0ste](https://github.com/k0ste) (25$) onetime

## Acknowledgements

Thanks to JetBrains IDEs and Sparklabs for their support.

<table>
  <thead>
    <tr>
      <th><a href="https://www.jetbrains.com/?from=jkroepke">JetBrains IDEs</a></th>
      <th><a href="https://www.sparklabs.com/viscosity">Sparklabs</a></th>
      <th><a href="https://rafaelalex.de/">Rafael Alex (Logo Design)</a></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <p align="center">
          <a href="https://www.jetbrains.com/?from=jkroepke">
            <picture>
              <source srcset="https://www.jetbrains.com/company/brand/img/logo_jb_dos_3.svg" media="(prefers-color-scheme: dark)">
              <img src="https://resources.jetbrains.com/storage/products/company/brand/logos/jetbrains.svg" style="height: 50px">
            </picture>
          </a>
        </p>
      </td>
      <td>
        <p align="center">
          <a href="https://www.sparklabs.com/viscosity">
            <img src="https://www.sparklabs.com/static/other/logo_assets/logo_cropped.png" alt="Sparklabs Viscosity logo" style="height: 100px">
          </a>
        </p>
      </td>
      <td>
        <p align="center">
          <a href="https://rafaelalex.de/">
            <img src="https://rafaelalex.de/logo-rafaelalex.svg" alt="Sparklabs Viscosity logo" style="height: 100px">
          </a>
        </p>
      </td>
    </tr>
  </tbody>
</table>
