% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R, R/functions-EnsDb.R
\name{addFilter,EnsDb-method}
\alias{addFilter,EnsDb-method}
\alias{addFilter}
\alias{dropFilter,EnsDb-method}
\alias{dropFilter}
\alias{activeFilter,EnsDb-method}
\alias{activeFilter}
\alias{filter}
\title{Globally add filters to an EnsDb database}
\usage{
\S4method{addFilter}{EnsDb}(x, filter = AnnotationFilterList())

\S4method{dropFilter}{EnsDb}(x)

\S4method{activeFilter}{EnsDb}(x)

filter(x, filter = AnnotationFilterList())
}
\arguments{
\item{x}{The \code{\linkS4class{EnsDb}} object to which the filter should be
added.}

\item{filter}{The filter as an
\code{\link[AnnotationFilter]{AnnotationFilter}},
\code{\link[AnnotationFilter]{AnnotationFilterList}} or filter
expression. See}
}
\value{
\code{addFilter} and \code{filter} return an \code{EnsDb} object
    with the specified filter added.

    \code{activeFilter} returns an
    \code{\link[AnnotationFilter]{AnnotationFilterList}} object being the
    active global filter or \code{NA} if no filter was added.

    \code{dropFilter} returns an \code{EnsDb} object with all eventually
    present global filters removed.
}
\description{
These methods allow to set, delete or show globally defined
    filters on an \code{\linkS4class{EnsDb}} object.

    \code{addFilter}: adds an annotation filter to the \code{EnsDb} object.

\code{dropFilter} deletes all globally set filters from the
    \code{EnsDb} object.

\code{activeFilter} returns the globally set filter from an
    \code{EnsDb} object.

\code{filter} filters an \code{EnsDb} object. \code{filter} is
    an alias for the \code{addFilter} function.
}
\details{
Adding a filter to an \code{EnsDb} object causes this filter to be
    permanently active. The filter will be used for all queries to the
    database and is added to all additional filters passed to the methods
    such as \code{\link{genes}}.
}
\examples{
library(EnsDb.Hsapiens.v86)
edb <- EnsDb.Hsapiens.v86

## Add a global SeqNameFilter to the database such that all subsequent
## queries will be applied on the filtered database.
edb_y <- addFilter(edb, SeqNameFilter("Y"))

## Note: using the filter function is equivalent to a call to addFilter.

## Each call returns now only features encoded on chromosome Y
gns <- genes(edb_y)

seqlevels(gns)

## Get all lincRNA gene transcripts on chromosome Y
transcripts(edb_y, filter = ~ gene_biotype == "lincRNA")

## Get the currently active global filter:
activeFilter(edb_y)

## Delete this filter again.
edb_y <- dropFilter(edb_y)

activeFilter(edb_y)
}
\seealso{
\code{\link{Filter-classes}} for a list of all supported filters.
}
\author{
Johannes Rainer
}
